#pragma once

/*! 
	@file SBTE.h
	Saboten Engine wb_[t@C
*/ 

#include <windows.h>



namespace SBTE
{

// --------------------------------------------------------------------------
// ^
// --------------------------------------------------------------------------
typedef char	SBTE_CHAR;		//!< ^
typedef UINT32	SBTE_UID;		//!< FXȃ\[XID
typedef UINT32	SPDEF_ID;		//!< XvCg`ID
typedef UINT32	SP_ID;			//!< XvCgID
typedef UINT32	GMSP_ID;		//!< GMXvCgID
typedef UINT32	CAMERA_ID;		//!< JID
typedef UINT32	MEMORY_ID;		//!< LӂȃubNIDB֐ŃlCeBu|C^ɕϊł܂B

}
// --------------------------------------------------------------------------
// bZ[WvV[WAR[obN֐^
// --------------------------------------------------------------------------

//! bZ[WvV[WR[obN
typedef LRESULT (*SBTE_WINDOW_MESSAGE_PROC_FUNC)( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam , BOOL& b_message_proced );	

//! D3DDeviceZbg̃R[obN
typedef void (*SBTE_DEVICE_RESET_PROC_FUNC)( void );

//! D3DDeviceXgÃR[obN
typedef void (*SBTE_DEVICE_RESTORE_PROC_FUNC)( void );

//! XN[TCỸR[obN
typedef void (*SBTE_WINDOW_RESIZE_PROC_FUNC)( SBTE::SBTE_UID screen_name , UINT32 width , UINT32 height );

// --------------------------------------------------------------------------
// }N
// --------------------------------------------------------------------------
//! @def }N
#define SBTE_SUCCEEDED( __RES__ )	( (__RES__) == SBTE::RESULT__SUCCEEDED )

//! @def s}N
#define SBTE_FAILED( __RES__ )		( (__RES__) != SBTE::RESULT__SUCCEEDED )


namespace SBTE
{
#pragma pack(push , 8)
#pragma pack(show)
// --------------------------------------------------------------------------
//! SBTE֐̖߂l^
enum RESULT
{
	RESULT__SUCCEEDED			= 0,	//!< 

	RESULT__INPUT_LOG_IS_EMPTY,			//!< GetNextInputDevicesLog()ɂāASẴO擾ɕԂB

	RESULT__REQUEST_CLOSE_APP,			//!< UpdateSBTE()Ivoi{^Ȃǁj
	RESULT__PENDING_AT_DEVICE_LOST,		//!< foCXXgoăXgAۗ

	RESULT__FAILED				= 0xffffffff,	//!< s
};

// --------------------------------------------------------------------------
//! O[h^
enum LOG_MODE
{
	LOG_NO_RECORD		= 0,	//!< Oo͂Ȃ
	LOG_SIMPLE			= 1,	//!< ȈՂȃOo͂
	LOG_VERBOSE			= 2,	//!< ڍׂȃOo͂

	LOG_F32				= 0xffffffff,
};

// --------------------------------------------------------------------------
// C[֘A
// --------------------------------------------------------------------------
//! C[̕`p[^FɃR[obN֐ɓn
struct LAYER_PRESENT_PARAMS
{
	// ------------------------------------------------------------------
	// WindowsŗL̃p[^
	LPDIRECT3DDEVICE9*	ppD3DDevice;		//!< D3DDevice|C^
	D3DVIEWPORT9*		pViewPort;			//!< `pr[|[g
	LPDIRECT3DTEXTURE9	ppTexture;			//!< `peNX`
	// ------------------------------------------------------------------

	SBTE_UID	LayerID;					//!< C[ID

	// obNobt@֓]ۂ̂S_ւ̎Q
	float*		pvPt;						//!< obNobt@]p_Pos [4x2]
	float*		pvUV;						//!< obNobt@]p_UV [4x2]
	float*		pvColor;					//!< obNobt@]p_Color [4x4]

	// ̑p[^ւ̎Q
	UINT32*		pPriority;					//!< vCIeBlւ̎Q
	UINT32*		pClearColor;				//!< NAJ[lւ̎Q
	float*		pfClearZ;					//!< NAZlւ̎Q
	BOOL*		pbEnableRender;				//!< _OLݒlւ̎Q
	BOOL*		bClearColor;				//!< NAJ[Lݒlւ̎Q
	BOOL*		bClearZ;					//!< OAZLݒlւ̎Q

	// Read only params
	UINT32		LayerWidth;					//!< C[̃TCY()
	UINT32		LayerHeight;				//!< C[̃TCY()

	UINT32		ReserveWidth;				//!< C[̊mۃTCY() : DirectXȂ2^n
	UINT32		ReserveHeight;				//!< C[̊mۃTCY() : DirectXȂ2^n
};

// --------------------------------------------------------------------------
// C[̃R[obN֐^
// --------------------------------------------------------------------------
//! C[R[obN֐̌^
typedef		BOOL (*LAYER_CUSTOM_PROCESS_CALLBACK_FUNC)( LAYER_PRESENT_PARAMS* p_lpp );

//! C[̃TCYOR[obN֐̌^
typedef		BOOL (*CALLBACK_FUNC__LAYER_PRE_RESIZE_CUSTOM_PROCESS)( const SBTE::LAYER_PRESENT_PARAMS* p_lpp
								  , UINT32& ret_layer_new_width , UINT32& ret_layer_new_height
								  , UINT32& ret_layer_new_logical_width , UINT32& ret_layer_new_logical_height
								  , UINT32 screen_new_width , UINT32 screen_new_height );

//! C[̃TCY㏈R[obN֐̌^
typedef		BOOL (*CALLBACK_FUNC__LAYER_POST_RESIZE_CUSTOM_PROCESS)( const SBTE::LAYER_PRESENT_PARAMS* p_lpp
								  , UINT32& ret_layer_draw_rect_left , UINT32& ret_layer_draw_rect_top
								  , UINT32& ret_layer_draw_rect_width , UINT32& ret_layer_draw_rect_height
								  , UINT32 layer_new_width , UINT32 layer_new_height
								  , UINT32 screen_new_width , UINT32 screen_new_height );

// --------------------------------------------------------------------------
//! C[̐p[^
struct LAYER_PARAMS
{
	const SBTE_CHAR*	pName;		//!< C[

	//! C[̃GCAX
	/*! Lȕʂ̃C[̖Ow肷ƁÃC[ɍۂ鑀
		AliasɎw肵C[ɑ΂鑀ɂȂB
		`敉׃IvV̍ɉăC[̍팸ꍇȂǂɎgB
	*/
	const SBTE_CHAR*	pAliasName;

	SBTE_UID			ScreenID;	//!< (\) 0w肷

	// ------------------------------------------------------------------
	// WindowsŗL̃p[^
	D3DFORMAT	ColorFormat;		//!< _O^[Qbg̃tH[}bg

	BOOL		bEnableDepthBuffer;	//!< fvXobt@̐ݒ
	D3DFORMAT	DepthFormat;

	UINT32		LayerWidth;			//!< C[̃TCY()
	UINT32		LayerHeight;		//!< C[̃TCY()

	UINT32		ReserveWidth;		//!< C[̊mۃTCY() : DirectXȂ2^n
	UINT32		ReserveHeight;		//!< C[̊mۃTCY() : DirectXȂ2^n

	UINT32		LogicalWidth;		//!< XvCgp_TCY()
	UINT32		LogicalHeight;		//!< XvCgp_TCY()

	INT32		ScreenDrawPosX;		//!< XN[ւ̓]` X
	INT32		ScreenDrawPosY;		//!< XN[ւ̓]` Y
	UINT32		ScreenDrawWidth;	//!< XN[ւ̓]` Width
	UINT32		ScreenDrawHeight;	//!< XN[ւ̓]` Height

	// ------------------------------------------------------------------

	UINT32		Priority;			//!< C[̗DxA傫l̃C[ɕ`悳B
	UINT32		ClearColor;			//!< NAJ[
	float		fClearZ;			//!< NAZl
	BOOL		bClearColor;		//!< `JnOɎwJ[ŃNA
	BOOL		bClearZ;			//!< `JnOɎwZlŃNA

	// R[obN
	LAYER_CUSTOM_PROCESS_CALLBACK_FUNC		pfuncInitialize;			//!< C[̏ɌĂ΂R[obN֐BVF[_[̏ȂǂɁB
	LAYER_CUSTOM_PROCESS_CALLBACK_FUNC		pfuncPreRender;				//!< BeginSceneɌĂ΂R[obN֐BVF[_[̏ȂǂɁB
	LAYER_CUSTOM_PROCESS_CALLBACK_FUNC		pfuncPreEffect;				//!< PreRenderANAOɌĂ΂R[obN֐BNULLɐݒAFALSEԂƁAC[NAB
	LAYER_CUSTOM_PROCESS_CALLBACK_FUNC		pfuncActivate;				//!< `ΏۃC[ƂȂɌĂ΂R[obN֐BVF[_[̐ݒȂǂɁB
	LAYER_CUSTOM_PROCESS_CALLBACK_FUNC		pfuncPostRender;			//!< obNobt@ւ̓]ʒOɌĂ΂R[obN֐BFALSEԂƁA]ʂLZB|XgGtFNgȂǂɁB
	LAYER_CUSTOM_PROCESS_CALLBACK_FUNC		pfuncRelease;				//!< C[̍폜ɌĂ΂R[obN֐BVF[_[̊JȂǂɁB
	CALLBACK_FUNC__LAYER_PRE_RESIZE_CUSTOM_PROCESS	pfuncPreResize;		//!< XN[TCY钼OɌĂ΂R[obN֐B
	CALLBACK_FUNC__LAYER_POST_RESIZE_CUSTOM_PROCESS	pfuncPostResize;	//!< XN[TCYꂽŌĂ΂R[obN֐B
};

// --------------------------------------------------------------------------
//!	XvCg`p[^
struct SPRITE_DEFINE_PARAMS
{
	INT32			Priority;											//!< DxFl傫قǎOɕ`B20bit̂ݗL
	BOOL			bAnimation;											//!< UVAj[VLɂB
	BOOL			bStretchH;											//!< C[̘_TCYɍ킹āAC[Wgk
	BOOL			bStretchV;											//!< C[̘_TCYɍ킹āAC[Wgk
	BOOL			bCenterPoint;										//!< C[W̒\W_ɂ
	const SBTE_CHAR*	pstrImagePath;										//!< C[W̃pXFhCu^[t̐΃pX.exȇ΃pX										<< vmF
	INT32			HorizontalOrigin;									//!< XvCgX\Wn[0:[_ŉE+][1:S_ŉE+][2:E[_ō+]
	INT32			VerticalOrigin;										//!< XvCgY\Wn[0:[_ŉ+][1:S_ŏ+][2:E[_ŉ+]	<< vmF
	BOOL			bAutoAnimation;										//!< UVAj[VFoߎԂɏ]ĎŃAj[V
	BOOL			bAutoLoop;											//!< UVAj[VFŃ[v
	BOOL			bMatrixAnimation;									//!< UVAj[VFsƗ𕪗Aj[V
	float			fAutoStep;											//!< UVAj[VFAj[VsƂ́AR}̎[sec]
	INT32			AnimationCount;										//!< UVAj[VFőR}
	INT32			AnimationChipWidth;									//!< UVAj[VFR}TCY()
	INT32			AnimationChipHeight;								//!< UVAj[VFR}TCY()
	BOOL			bSaturation;										//!< Zs
	BOOL			bAntiAlias;											//!< A`GCAXs
	BOOL			bReverseH;											//!< C[W𐅕ɔ]
	BOOL			bReverseV;											//!< C[W𐂒ɔ]
};

// --------------------------------------------------------------------------
//! v~eBuXvCg^Cv
enum TOFU_SPRITE_TYPE
{
	TOFU_SPRITE_TYPE_POINT			= 0,	//!< 1sNZ̓_XvCg
	TOFU_SPRITE_TYPE_LINE,					//!< CXvCg
	TOFU_SPRITE_TYPE_RECTANGLE,				//!< `XvCg
	TOFU_SPRITE_TYPE_RECTANGLE_LINE,		//!< Cɂ`()
	TOFU_SPRITE_TYPE_SPRITE,				//!< v~eBuXvCgȊO

	TOFU_SPRITE_TYPE_SIZE,
	TOFU_SPRITE_TYPE_F32			= 0xffffffff
};

// --------------------------------------------------------------------------
//! tHgp[^
struct FONT_PARAMS
{
	UINT32	uiHeight;					//!< SW
	UINT32	uiWeight;					//!< TCY(pt)
	BOOL	bItalic;					//!< C^bN
	BOOL	bUnderLine;					//!< 
	BOOL	bStrikeOut;					//!< ł
	UINT32	uiFixedPitch;				//!< Œ蕝ɂ
	UINT32	uiDefaultCRYStep;			//!< ftHg̉ssNZ
	BOOL	bAA;						//!< A`GCAXLɂ
	TCHAR*	pstrFontName;				//!< tHgB"lrSVbN"ȂǁB

	FONT_PARAMS(){ ZeroMemory( this , sizeof(FONT_PARAMS) ); };
};

// --------------------------------------------------------------------------
//! vZς݃RW̎擾p\
struct GMSP_CALCED_COLLISION_PARAMS
{
	static const UINT32 DATA_COUNT = 2;

	SBTE_UID	PartsName;					//!< p[c
	UINT32		Type;						//!< 0:sphere 1:capsule
	UINT32		Index;						//!< ޕʃCfbNXł͂ȂAʂԍ(Sph2ACap4Index=3ȂACap2)

	float		v2Collision_CenterBegin[2];	//!< Sph̒SCap̎n_
	float		v2Collision_End[2];			//!< Cap̏I_F͖̎
	float		fRadius;					//!< a

	/*! LtOB̒lFALSEŃRW擾ꂽꍇ́A
	{̃RWGMSP_SetCollisionSetting()֐b_force_calcp[^ŗLꂽƂ\܂B
	*/
	BOOL		bEnable;

	INT32		aIntParams[DATA_COUNT];		//!< ^f[^
	float		aFloatParams[DATA_COUNT];	//!< _^f[^
};

// --------------------------------------------------------------------------
//! C[Wp[^擾p^
struct GMSP_PARTS_IMAGE_PARAMS
{
	UINT32		ImageColor;
	UINT32		IPAnimatedFrame;
	UINT32		IPAnimatedRow;

	UINT32		Priority;
	BOOL		bVisible;
	BOOL		bReverseH;
	BOOL		bReverseV;

	GMSP_PARTS_IMAGE_PARAMS()
		: ImageColor( 0 )
		, IPAnimatedFrame( 0 )
		, IPAnimatedRow( 0 )
		, Priority( 0 )
		, bVisible( FALSE )
		, bReverseH( FALSE )
		, bReverseV( FALSE )
	{};
};

// --------------------------------------------------------------------------
//! ̓foCX񋓂Œ\̓p[^
struct INPUT_DEVICE_ENUM_MINIMUM_CAPS
{
	BOOL	bEnableKeyboard;						//!< L[{[hgp
	BOOL	bEnableMouse;							//!< }EXgp
	BOOL	bEnableGameController;					//!< Q[Rg[[gp

	UINT32	dwMinimumKeyboardButtonNumber;			//!< gpL[{[h̍Œ{^

	UINT32	dwMinimumMouseAxisNumber;				//!< gp}EX̍ŒᎲ
	UINT32	dwMinimumMouseButtonNumber;				//!< gp}EX̍Œ{^

	UINT32	dwMinimumGameControllerAxisNumber;		//!< gpQ[Rg[[̍Œgp
	UINT32	dwMinimumGameControllerButtonNumber;	//!< gpQ[Rg[[̍Œgp{^
	UINT32	dwMinimumGameControllerPovNumber;		//!< gpQ[Rg[[̍ŒgpPov

	INPUT_DEVICE_ENUM_MINIMUM_CAPS()
		: bEnableKeyboard( FALSE )
		, bEnableMouse( FALSE )
		, bEnableGameController( FALSE )
		, dwMinimumKeyboardButtonNumber( 0 )
		, dwMinimumMouseAxisNumber( 0 )
		, dwMinimumMouseButtonNumber( 0 )
		, dwMinimumGameControllerAxisNumber( 0 )
		, dwMinimumGameControllerButtonNumber( 0 )
		, dwMinimumGameControllerPovNumber( 0 )
	{};

};

// --------------------------------------------------------------------------
//! ̓foCX̓̓O
/*!
	Cxg̓Z̏ԂωƂɂ̂ݔBJnƉs̓AvŔ肷KvB
*/
struct INPUT_DEVICE_LOG
{
	UINT32	dwDeviceID;			//!< ̓foCXIDBL[{[h̏ꍇ0
	UINT32	dwCellID;			//!< ̓ZIDBL[{[h̏ꍇ"DIK_*"̒l
	float	fAnalogValue;		//!< K͒l( -1`1 )A( ȊO0`1 )
	UINT32	dwDigitalValue;		//!< OFF:0 ON:1

	INPUT_DEVICE_LOG()
		: dwDeviceID( 0 )
		, dwCellID( 0 )
		, fAnalogValue( 0.0f )
		, dwDigitalValue( 0 )
	{};
};

#pragma pack( pop )
#pragma pack(show)

// --------------------------------------------------------------------------
// ֐
// --------------------------------------------------------------------------
// VXen
// --------------------------------------------------------------------------
// 
//! GW̏
/*!
	@par EChEƃfoCX̃[h
		(p_d3ddevice == NULL) && (h_wnd == NULL) : foCXƃEChEGW쐬BP̃EChÊ݁BtXN[\B@n
		(p_d3ddevice == NULL) && (h_wnd != NULL) : Avō쐬EChEɑ΂āAGW쐬foCXŕ`BWPFȂǁB̃EChE\AtXN[͂łȂB@n
		(p_d3ddevice != NULL) && (h_wnd == NULL) : ̑gݍ킹͎włȂB@n
		(p_d3ddevice != NULL) && (h_wnd != NULL) : Avō쐬foCX𗘗pāAAv쐬EChEɕ`BDXCuȂǁB@n
	      
	@par TCYR[obNɂ
		  (p_d3ddevice != NULL) && (h_wnd != NULL) : TCYsB@n
	      (p_d3ddevice == NULL) && (h_wnd != NULL) : TCY\AAvŃbZ[WsAGW̃TCY֐ĂяoƁAR[obNԂB@n
	      (p_d3ddevice != NULL) && (h_wnd != NULL) : TCY\AB@n
	
	@par AP[^ubNɂ
	GWgq[vAP[^̃TCYݒ肷B@n
	GW̓q[vŒ蒷xŒ萔̃mۂāA󂫂ꍇ::new()̑ɂ烁mۂėpB@n
	@code
		UINT32 allocs[7];
		allocs[0] = 500;  allocs[1] = 20000;
		allocs[2] = 1000; allocs[3] = 2000;
		allocs[4] = 2000; allocs[5] = 1000;
		allocs[6] = 0;
	@endcode
	Ⴆ΁AL̂悤ɐݒ肵allocsnƁA500oCg x 20000ubNA1000oCg x 2000ubNA2000oCg x 1000ubNmۂB@n
	f[^̖0ݒ肵ďI[𖾎KvB@n
	::new()ɏꂽǂ́AGW̃Oɕ\B@n

	@par CgAP[^ɂ
	CgAP[^̓TCYPނ݂̂̃q[vAP[^ŁAGWœɕpɂalloc/freef[^ɎgpB@n
	
	@param[out] ret_layer_id C[IDԂ
	@param[in] screen_width EBhẼTCY()AEBhEȂꍇAC[̃ftHglTCYƂĎQƂ
	@param[in] screen_height EBhẼTCY()AEBhEȂꍇAC[̃ftHglTCYƂĎQƂ
	@param[in] p_d3ddevice D3DDevice9|C^nƁAGW͎ÕfoCX쐬ɂ̃foCX𗘗pBp_d3ddevice̎QƃJE^オ܂B
	@param[in] h_wnd EChEAvō鎞̃EChEnhBNULLȂAGWEChE쐬B
	@param[in] pstr_window_class_name h_wnd = NULL̎́AEChENXl[Bh_wnd != NULL̂̎NULL
	@param[in] pstr_window_title_caption h_wnd = NULL̎́AEChE^CgLvVBh_wnd != NULL̂̎NULL
	@param[in] b_windowed p_d3ddevice == NULL̎AEChE[hŋNȂ1
	@param[in] window_pos_x h_wnd == NULL̎̃EChEW(X)Bpos_x/ŷǂ炩̒lINT_MAXȂftHgl
	@param[in] window_pos_y h_wnd == NULL̎̃EChEW(Y)B
	@param[in] adapter_index p_d3ddevice == NULL̎D3DDevicẽA_v^[CfbNX
	@param[in] refresh_rate p_d3ddevice == NULL̎D3DDevice̐g
	@param[in] p_layer_params C[̃p[^ NULLȂAftHglgp
	@param[in] p_allocator_block_list AP[^ubN̐ݒBNULLȂftHgTCYŊmۂ
	@param[in] light_allocator_block_size CgAP[^̃ubNTCY
	@param[in] light_allocator_block_count CgAP[^̃ubN
	@param[in] max_sprite_texture_size XvCgobt@eNX`̍őTCY=XvCg̍őTCY(`XY:ꖇ̃XvCgC[W̃TCY-4𒴂邱Ƃ͂ł܂)0ȂAfoCX̍ől
	@param[in] font_temporary_texture_size tHgp[NeNX`̃TCYB0ȂAfoCX̍ől
	@param[in] b_y_reverse Y+ɂ
	@param[in] b_rot_reverse -Y]+ɂ
	@param[in] p_win_msg_proc_func h_wnd == NULLȂAbZ[WvV[W̊֐Ă
	@param[in] p_device_reset_proc_func p_d3ddevice == NULLȂAfoCXZbgɂ̊֐Ă΂
	@param[in] p_device_restore_proc_func p_d3ddevice == NULLȂAfoCXXgAɂ̊֐Ă΂
	@param[in] p_window_resize_proc_func h_wnd == NULLp_d3ddevice == NULLȂAEChETCYύXɂ̊֐Ă΂
	@param[in] log_mode Oo̓[h
	@param[in] pstr_log_name Ot@CBNULLȂst@C-gq+.log
*/
__declspec(dllexport) RESULT InitializeSBTE(
	  SBTE_UID& ret_layer_id											// C[IDԂ
	, UINT32 screen_width												// EBhẼTCY()AEBhEȂꍇAC[̃ftHglTCYƂĎQƂ
	, UINT32 screen_height												// EBhẼTCY()AEBhEȂꍇAC[̃ftHglTCYƂĎQƂ
	, LPDIRECT3DDEVICE9 p_d3ddevice = NULL								// D3DDevice9|C^nƁAGW͎ÕfoCX쐬ɂ̃foCX𗘗pBp_d3ddevice̎QƃJE^オ܂B
	, HWND h_wnd = NULL													// EChEAvō鎞̃EChEnhBNULLȂAGWEChE쐬B
	, const SBTE_CHAR* pstr_window_class_name = NULL					// h_wnd = NULL̎́AEChENXl[Bh_wnd != NULL̂̎NULL
	, const SBTE_CHAR* pstr_window_title_caption = NULL					// h_wnd = NULL̎́AEChE^CgLvVBh_wnd != NULL̂̎NULL
	, BOOL b_windowed = TRUE											// p_d3ddevice == NULL̎AEChE[hŋNȂ1
	, INT32 window_pos_x = INT_MAX										// h_wnd == NULL̎̃EChEW(X)Bpos_x/ŷǂ炩̒lINT_MAXȂftHgl
	, INT32 window_pos_y = INT_MAX										// h_wnd == NULL̎̃EChEW(Y)B
	, UINT32 adapter_index = 0											// p_d3ddevice == NULL̎D3DDevicẽA_v^[CfbNX
	, UINT32 refresh_rate = 60											// p_d3ddevice == NULL̎D3DDevice̐g
	, const LAYER_PARAMS* p_layer_params = NULL							// C[̃p[^ NULLȂAftHglgp
	, const UINT32* p_allocator_block_list = NULL						// AP[^ubN̐ݒBNULLȂftHgTCYŊmۂ
	, UINT32 light_allocator_block_size = 120							// CgAP[^̃ubNTCY
	, UINT32 light_allocator_block_count = 5000							// CgAP[^̃ubN
	, UINT32 max_sprite_texture_size = 0								// XvCgobt@eNX`̍őTCY=XvCg̍őTCY(`XY:ꖇ̃XvCgC[W̃TCY𒴂邱Ƃ͂ł܂)0ȂAfoCX̍ől
	, UINT32 font_temporary_texture_size = 0							// tHgp[NeNX`̃TCYB0ȂAfoCX̍ől
	, BOOL b_y_reverse = FALSE											// Y+ɂ
	, BOOL b_rot_reverse = FALSE										// -Y]+ɂ
	, SBTE_WINDOW_MESSAGE_PROC_FUNC p_win_msg_proc_func = NULL			// h_wnd == NULLȂAbZ[WvV[W̊֐Ă
	, SBTE_DEVICE_RESET_PROC_FUNC p_device_reset_proc_func = NULL		// p_d3ddevice == NULLȂAfoCXZbgɂ̊֐Ă΂
	, SBTE_DEVICE_RESTORE_PROC_FUNC p_device_restore_proc_func = NULL	// p_d3ddevice == NULLȂAfoCXXgAɂ̊֐Ă΂
	, SBTE_WINDOW_RESIZE_PROC_FUNC p_window_resize_proc_func = NULL		// h_wnd == NULLp_d3ddevice == NULLȂAEChETCYύXɂ̊֐Ă΂
	, LOG_MODE log_mode = LOG_NO_RECORD									// Oo̓[h
	, const char* pstr_log_name = NULL									// Ot@CBNULLȂst@C-gq+.log
);

//! GW̃t[XV
/*! 
	@param[in] f_elapsed_time oߎ[sec]
	@param[in] b_restore_render_target TRUEȂAĂяoɐݒ肳Ă_O^[Qbg𕜋AďIB
	@param[in] b_restore_set_textures TRUEȂAĂяoɕ`pɐݒ肳ĂeNX`𕜋AďIB
	@param[in] b_restore_depth_buffer TRUEȂAĂяoɕ`pɐݒ肳ĂfvXobt@𕜋AďIB
	@param[in] b_skip_rendering TRUEȂAXvCg̍XVĕ`ȂB

	@retval RESULT__REQUEST_CLOSE_APP GWIvo({^Ȃ)
	@retval RESULT__PENDING_AT_DEVICE_LOST foCXXgoăXgAۗ
*/ 
__declspec(dllexport) RESULT UpdateSBTE( float f_elapsed_time , BOOL b_restore_render_target = FALSE , BOOL b_restore_set_textures = FALSE , BOOL b_restore_depth_buffer = TRUE , BOOL b_skip_rendering = FALSE );

//! GW̉
__declspec(dllexport) RESULT ReleaseSBTE( void );

// --------------------------------------------------------------------------
//! ̓foCX̏
/*!
	VXeɐڑĂ̓foCXQAvP[VŎgp\ɂB

	@param[in] min_caps dl\ɂfoCX̍Œ\͂LqB
	@param[in] h_instance foCXgpEBhELAvP[ṼnhBNULLnꍇSBTEǗnhgBGetInstanceHandle֐NULLԂꍇ́A[U[ǗnhnKvB
	@param[in] h_wnd foCXgpEBhẼnhBNULLnꍇSBTEǗnhgBGetWindowHandle֐NULLԂꍇ́A[U[ǗnhnKvB
*/
__declspec(dllexport) RESULT InitializeInputDevices( INPUT_DEVICE_ENUM_MINIMUM_CAPS min_caps , HINSTANCE h_instance , HWND h_wnd );

//! ̓foCX̉
/*!
	VXeɐڑĂ̓foCXQB
*/
__declspec(dllexport) RESULT ReleaseInputDevices( void );

//! Lȓ̓foCX擾
/*!
	@param[out] ret_keyboard_count L[{[h̐
	@param[out] ret_controller_count Q[Rg[[̐
	@param[out] pa_ret_controller_ids Q[Rg[[ID\Amax_controller_count̒UINT32^z
	@param[in] max_controller_count 擾őQ[Rg[[
*/
__declspec(dllexport) RESULT GetControllers( UINT32& ret_keyboard_count , UINT32& ret_controller_count , UINT32* pa_ret_controller_ids , UINT32 max_controller_count );

//! ̓foCXXV
/*!
	VXeɐڑĂ̓foCXQB

	@param[in] elapsed oߎ
*/
__declspec(dllexport) RESULT UpdateInputDevices( float elapsed );

//! ̓foCX̓͗𓾂
/*!
	UpdateInputDevice()s܂łɓ͂ꂽ͒l̃O擾܂B@n
	RESULT__INPUT_LOG_IS_EMPTYԂ܂ŌJԂs邱ƂŁASĂ̓͂擾ł܂B
	RESULT__INPUT_LOG_IS_EMPTYԂ́Aret_input_device_logɓ͒l͕Ԃ܂B@n
	擾O̓VXeォ폜܂B

	@param[out] ret_input_device_log 擾郍Of[^̊i[B
*/
__declspec(dllexport) RESULT GetNextInputDevicesLog( INPUT_DEVICE_LOG& ret_input_device_log );

//! ̓foCX̖O𓾂
/*!
	@param[out] ret_str_name
	@param[in] max_name_size
*/
__declspec(dllexport) RESULT GetDeviceName( SBTE_CHAR* ret_str_name , UINT32 max_name_size , UINT32 device_id );

//! ̓foCX̃Z̐𓾂
/*!
	@param[out] ret_axes_x X̃Z
	@param[out] ret_axes_y ỸZ
	@param[out] ret_axes_z Z̃Z
	@param[out] ret_axes_other XYZȊO̎̃Z
	@param[out] ret_buttons {^̃Z
	@param[out] ret_povs POṼZ
	@param[in] device_id 擾ΏۃfoCXID
*/
__declspec(dllexport) RESULT GetControllerCellCount(
	  UINT32& ret_axes_x
	, UINT32& ret_axes_y
	, UINT32& ret_axes_z
	, UINT32& ret_axes_other
	, UINT32& ret_buttons
	, UINT32& ret_povs
	, UINT32 device_id );

//! ̓foCX̃Z𓾂
/*!
	ez̃TCÝAOGetControllerCellCount()擾܂B
	NULLnzɂĂ͎擾΂܂B

	@param[out] a_ret_axes_x 擾X̃ZID̈ꗗi[z
	@param[out] a_ret_axes_y 擾ỸZID̈ꗗi[z
	@param[out] a_ret_axes_z 擾Z̃ZID̈ꗗi[z
	@param[out] a_ret_axes_other 擾XYZȊO̎̃ZID̈ꗗi[z
	@param[out] a_ret_buttons 擾{^̃ZID̈ꗗi[z
	@param[out] a_ret_povs 擾PoṽZID̈ꗗi[z
	@param[in] device_id 擾ΏۃfoCXID
*/
__declspec(dllexport) RESULT GetControllerCells(
	  UINT32* pa_ret_axes_x
	, UINT32* pa_ret_axes_y
	, UINT32* pa_ret_axes_z
	, UINT32* pa_ret_axes_other
	, UINT32* pa_ret_buttons
	, UINT32* pa_ret_povs
	, UINT32 device_id );


// --------------------------------------------------------------------------
//! ^C}[쐬
__declspec(dllexport) RESULT CreateTimer( void );

//! ^C}[폜
__declspec(dllexport) RESULT DeleteTimer( void );

//! OUpdateTimer()/ResetTimer()̌oߎԂ𓾂
__declspec(dllexport) float UpdateTimer( void );

//! ^C}[Zbg
__declspec(dllexport) void ResetTimer( void );

// --------------------------------------------------------------------------
//! C[ǉ
/*! 
	@param[out] ret_layer_id ǉC[IDԂB
	@param[in] params 쐬郌C[̃p[^B
*/
__declspec(dllexport) RESULT AddLayer( SBTE_UID& ret_layer_id , const LAYER_PARAMS& params );

//! C[폜
/*! 
	@param[in] layer_id 폜郌C[IDB
*/
__declspec(dllexport) RESULT RemoveLayer( SBTE_UID layer_id );

//! \[XUID𓾂
/*!
	@param[in] resources_name Ώۃ\[X
*/
__declspec(dllexport) SBTE_UID GetResUID( const SBTE_CHAR* resources_name );

//! C[̃eNX`𓾂
/*!
	@param[out] p_ret_tex C[eNX`̃|C^
	@param[out] ret_layer_width C[̕
	@param[out] ret_layer_height C[̍
	@param[out] ret_reserved_width C[eNX`̕
	@param[out] ret_reserved_height C[eNX`̍
	@param[in] layer_id 擾郌C[ID
*/
__declspec(dllexport) RESULT GetLayerTexture( LPDIRECT3DTEXTURE9& p_ret_tex , UINT32& ret_layer_width , UINT32& ret_layer_height , UINT32& ret_reserved_width , UINT32& ret_reserved_height , SBTE_UID layer_id );

//! C[RenderTargeteNX`֕`悷邱Ƃ\񂷂BUpdateSBTE()sɕ`挋ʂB
/*!
	UpdateSBTE()sxɗ\͉B
	@param[in] p_dest_RT_texture
	@param[in] left
	@param[in] top
	@param[in] width
	@param[in] height
	@param[in] layer_id
*/
__declspec(dllexport) RESULT RegistTextureToRenderingLayer( LPDIRECT3DTEXTURE9 p_dest_RT_texture , UINT32 left , UINT32 top , UINT32 width , UINT32 height , SBTE_UID layer_id );


// --------------------------------------------------------------------------
//!	foCX\[X\߃Zbg
__declspec(dllexport) RESULT DeviceResourceManualReset( void );

//!	\߃ZbgfoCX\[X𕜌
/*!
	@param[in] b_do_not_callback_device_lost_funcs XgAR[obNĂ΂Ȃ
	@param[in] b_do_device_reset foCXZbgs
	@param[in] p_new_device foCX蒼ꍇ́ÄɐVfoCX|C^w肷B
			   foCXύXȂꍇ́ANULLw肷B
			   ÂfoCX́ASBTEǗ郊\[X̔jƂɎgp邽߁Å֐I܂ŔjȂŉB
	@param[in] b_req_old_device_release p_new_device != NULL̎AÂfoCXɑ΂ĂPRelease()s邩ǂw肵܂B
*/
__declspec(dllexport) RESULT DeviceResourceManualRestore( BOOL b_do_not_callback_device_lost_funcs = false , BOOL b_do_device_reset = true , LPDIRECT3DDEVICE9 p_new_device = NULL , BOOL b_req_old_device_release = FALSE );


//! eNX`gp󋵂̃Oo
__declspec(dllexport) RESULT ReportTextures( void );

//! XvCggp󋵂̃Oo
/*!
	@param[in] b_output_sprite_temp_texture XvCgobt@eNX`o͂
*/
__declspec(dllexport) RESULT ReportSprites( BOOL b_output_sprite_temp_texture = FALSE );

//! XN[gp󋵂̃Oo
__declspec(dllexport) RESULT ReportScreens( void );

//!	C[gp󋵂̃Oo
__declspec(dllexport) RESULT ReportLayers( void );

//!	C[̃C[Wt@C֕ۑ
/*!
	@param[in] layer_id
	@param[in] pstr_file_path_name
	@param[in] save_width
	@param[in] save_height
*/
__declspec(dllexport) RESULT SaveLayerImage( SBTE_UID layer_id , const SBTE_CHAR* pstr_file_path_name , UINT32 save_width = 0 , UINT32 save_height = 0 );


//! GW̊eW[̃o[W擾
/*!
	@param[out] ret_line_0 ԋppobt@Ps
	@param[in] line_0_size ԋppobt@Psڂ̃TCY
	@param[out] ret_line_1 ԋppobt@QsځANULLȂ擾Ȃ
	@param[in] line_1_size ԋppobt@Qsڂ̃TCY
	@param[out] ret_line_2 ԋppobt@RsځANULLȂ擾Ȃ
	@param[in] line_2_size ԋppobt@Rsڂ̃TCY
*/
__declspec(dllexport) RESULT GetModuleVersions( SBTE_CHAR* ret_line_0 , UINT32 line_0_size , SBTE_CHAR* ret_line_1 = NULL , UINT32 line_1_size = 0 , SBTE_CHAR* ret_line_2 = NULL , UINT32 line_2_size = 0 );

//! `𑜓xύX
/*!
	@param[in] screen_name @\i\j
	@param[in] width V
	@param[in] height V
	
	GWŃEChE쐬ꍇ́AύXłȂB
*/
__declspec(dllexport) RESULT ResizeScreenResolution( SBTE_UID screen_name ,  UINT32 width , UINT32 height );

//! D3DDevice9|C^擾
/*!
	|C^QueryInterface()ꂽ̂ł͂Ȃ̂ŁARelease()Ă͂ȂB@n
	ꂽ|C^D3DDevice9ExQueryInterface()邱ƂłB
*/
__declspec(dllexport) LPDIRECT3DDEVICE9 GetD3DDevice9( void );

//! DLL̃W[nh(hInstance)擾
__declspec(dllexport) HINSTANCE GetInstanceHandle( void );

//! EChEnh(hWnd)擾
/*!
	@param[in] screen_name @\i\j
*/
__declspec(dllexport) HWND GetWindowHandle( SBTE_UID screen_name = 0 );

//! tHg쐬
/*!
	@param[out] ret_h_font 쐬tHg̃nhԂ
	@paran[in] font_params tHg̃p[^\
*/
__declspec(dllexport) RESULT CreateFont( HFONT& ret_h_font , FONT_PARAMS& font_params );

//! tHgJ
/*!
	@paran[in] font_params JtHg̃nh
*/
__declspec(dllexport) RESULT ReleaseFont( HFONT h_font );


// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// XvCg֌W
// --------------------------------------------------------------------------
//! 摜t@CXvCg`쐬
/*!
	`́A"pstr_group_name/p_define_name"ƂȂ܂B
	
	@param[in] p_define_name ݒ肷`
	@param[in] sprite_define_params 쐬`̃p[^
	@param[in] pstr_group_name `̑O[v
	@param[out] p_ret_id 쐬`ID
*/
__declspec(dllexport) RESULT CreateSpriteDefine( const SBTE_CHAR* p_define_name , const SPRITE_DEFINE_PARAMS& sprite_define_params , const SBTE_CHAR* pstr_group_name = NULL , SPDEF_ID* p_ret_id = NULL );

//! GMSPXvCg`P[h
/*!
	gsbAgmbt@CGMSPConv.exeggmsAgmmt@C琶܂B@n
	قȂvWFNg̃t@Cgݍ킹Ă͂܂B
	`́A"pstr_group_name/p_define_name"ƂȂ܂B
	
	@param[in] p_define_name ݒ肷`
	@param[in] pstr_gsb_path gsbt@C̃pXBexe΂hCu^[t̐΃pXB
	@param[in] pstr_gmb_path gmbt@C̃pXBexe΂hCu^[t̐΃pXB
	@param[in] pstr_group_name `̑O[v
	@param[out] p_ret_id 쐬`ID
*/
__declspec(dllexport) RESULT LoadGMSpriteDefine( const SBTE_CHAR* p_define_name , const SBTE_CHAR* pstr_gsb_path , const SBTE_CHAR* pstr_gmb_path , const SBTE_CHAR* pstr_group_name = NULL , SPDEF_ID* p_ret_id = NULL );

//! GMSPXvCg`ꊇ[ht@CɊ܂܂`擾܂B
/*!
	ꊇ[ht@CGMSPConv.exegĐ܂B
	
	@param[in] pstr_defines_file_path GMSPꊇ[ht@C̃pXBexe΂hCu^[t̐΃pXB
*/
__declspec(dllexport) UINT32 GetGMSpriteDefinesCount( const SBTE_CHAR* pstr_defines_file_path );

//! GMSPXvCg`ꊇ[h
/*!
	ꊇ[ht@CGMSPConv.exegĐ܂B@n
	`́A"pstr_group_name/(c[Ŏw肵`)"ƂȂ܂B
	
	@param[in] pstr_defines_file_path GMSPꊇ[ht@C̃pXBexe΂hCu^[t̐΃pXB
	@param[in] pstr_group_name `̑O[v
	@param[out] pa_ret_define_names [h`̈ꗗi[B`ID擾ꍇ́A[GetGMSpriteDefinesCount()̕Ԃl * 1024 * sizeof(SBTE_CHAR)]oCg̃TCYmۂobt@̃|C^n܂B
	@param[out] pa_ret_ids 쐬`ID̈ꗗi[B`ID擾ꍇ́A[GetGMSpriteDefinesCount()̕Ԃl * sizeof(SPDEF_ID)]oCg̃TCYmۂobt@̃|C^n܂B
	@param[in] ret_ids_array_size obt@̃TCYApa_ret_define_names , pa_ret_idsɃobt@̃|C^nꍇɁAGetGMSpriteDefinesCount()̕Ԃln܂B

	@par `ID̎擾@
	pa_ret_define_names , pa_ret_idsret_ids_array_sizeŎw肵TCỸobt@̃|C^nƁA[h`ID̈ꗗ𓾂邱Ƃł܂B@n
	`&(pa_ret_define_names[i*1024])1000ƂƂĕԂApa_ret_ids[i]ցA̒`ɑΉ`IDԂ܂B@n
	Ƃ`IDGetResUID( define_name )Ő邱Ƃł̂ŁAAv\ߒ`mĂȂ擾Kv͂܂B

*/
__declspec(dllexport) RESULT LoadGMSpriteDefines( const SBTE_CHAR* pstr_defines_file_path , const SBTE_CHAR* pstr_group_name = NULL , SBTE_CHAR* pa_ret_define_names = NULL , SPDEF_ID* pa_ret_ids = NULL , UINT32 ret_ids_array_size = 0 );

//! XvCg`jv
/*!
	@param[in] define_id `ID
*/
__declspec(dllexport) RESULT ReleaseSpriteDefine( SPDEF_ID define_id );

//! XvCg`jv
/*!
	@param[in] p_define_name `
*/
__declspec(dllexport) RESULT ReleaseSpriteDefine( const SBTE_CHAR* p_define_name );

//! XvCg`O[vPʂŔjv
/*!
	@param[in] pstr_group_name O[v

	@retval 
*/
__declspec(dllexport) UINT32 ReleaseSpriteDefines( const SBTE_CHAR* pstr_group_name );

//! XvCg`̔jvs
__declspec(dllexport) RESULT RefreshSpriteDefine( void );


//! XvCg쐬
/*!
	@param[out] ret_sprite_id 쐬XvCgID 
	@param[in] define_id XvCg`ID
	@param[in] layer_id `惌C[ID
*/
__declspec(dllexport) RESULT CreateSprite( SP_ID& ret_sprite_id , SPDEF_ID define_id , SBTE_UID layer_id );

//! XvCg쐬
/*!
	@param[in] ret_sprite_id 쐬XvCgID
	@param[in] p_define_name XvCg`
	@param[in] layer_id `惌C[ID
*/
__declspec(dllexport) RESULT CreateSprite( SP_ID& ret_sprite_id , const SBTE_CHAR* p_define_name , SBTE_UID layer_id );

//! XvCgj
/*!
	@param[in] sprite_id XvCgID
*/
__declspec(dllexport) RESULT ReleaseSprite( SP_ID sprite_id );

//! GMXvCg쐬
/*!
	@param[out] ret_sprite_id 쐬GMXvCgID
	@param[in] define_id GMXvCg`ID
	@param[in] layer_id `惌C[ID
*/
__declspec(dllexport) RESULT CreateGMSprite( GMSP_ID& ret_sprite_id , SPDEF_ID define_id , SBTE_UID layer_id );
//! GMXvCg쐬
/*!
	@param[out] ret_sprite_id 쐬GMXvCgID
	@param[in] p_define_name GMXvCg`
	@param[in] layer_id `惌C[ID
*/
__declspec(dllexport) RESULT CreateGMSprite( GMSP_ID& ret_sprite_id , const SBTE_CHAR* p_define_name , SBTE_UID layer_id );

//! GMXvCgj
/*!
	@param[in] sprite_id GMXvCgID
*/
__declspec(dllexport) RESULT ReleaseGMSprite( GMSP_ID sprite_id );

//! XvCg쐬
/*!
	jReleaseSprite()ōs܂B

	@param[out] ret_sprite_id 쐬XvCgID
	@param[in] h_font gptHg̃nhBNULLw肷邩AȒlw肵ꍇ́AftHg̃tHggB
	@param[in] pstr_message ւ̃|C^B֐Iɂ̕ێKv͂܂B
	@param[in] layer_id `ΏƃC[ID
	@param[in] ui_priority `Dx
	@param[in] ui_horizontal_origin XvCgX\Wn[0:[_ŉE+][1:S_ŉE+][2:E[_ō+]
	@param[in] ui_vertical_origin XvCgY\Wn[0:[_ŉ+][1:S_ŏ+][2:E[_ŉ+]
	@param[in] b_stretch_h C[̘_TCYɍ킹āA`C[Wgk
	@param[in] b_stretch_v C[̘_TCYɍ킹āA`C[Wgk
	@param[in] b_saturation Zs
	@param[in] b_aa A`GCAXs
	@param[in] b_fix TRUEȂŒ蕶񕝂ŕ`悷AFALSEȂϕ񕝂ŕ`悷B
	@param[in] cr_step_y s̍B0ȂtHg쐬Ɏw肵ftHglgB
	@param[in] f_view_scale `g嗦
	@param[in] b_baseline_placement Y_x[XCʒuɂ
	@param[in] b_right_align El߂ŕ`悷
	@param[in] b_bg wiFLɂBwiF͎w肵ui_priority-1Dx̃XvCgɂĕ`悳܂B]đ̃XvCgƂ̏dˍ킹lꍇɂ́ÃXvCg2ȏDx𗣂ĂB
	@param[out] p_ret_cell_width_table X̕̕𕶎̔zŕԂ(̂2oCg)
*/
__declspec(dllexport) RESULT CreateInscription(
	  SP_ID& ret_sprite_id
	, HFONT h_font
	, const WCHAR* pstr_message
	, SBTE_UID layer_id
	, UINT32 ui_priority
	, UINT32 ui_horizontal_origin
	, UINT32 ui_vertical_origin
	, BOOL b_stretch_h
	, BOOL b_stretch_v
	, BOOL b_saturation
	, BOOL b_aa
	, BOOL b_fix
	, UINT32 cr_step_y
	, float f_view_scale = 1.0f
	, BOOL b_baseline_placement = TRUE
	, BOOL b_right_align = FALSE
	, BOOL b_bg = FALSE
	, MEMORY_ID* p_ret_cell_width_table = NULL
	);

//! v~eBuXvCg쐬
/*!
	jReleaseSprite()ōs܂B

	@param[out] ret_sprite_id 쐬v~eBuXvCgID
	@param[in] type v~eBu̎
	@param[in] layer_id `ΏƃC[ID
	@param[in] ui_priority `Dx
	@param[in] ui_horizontal_origin XvCgX\Wn[0:[_ŉE+][1:S_ŉE+][2:E[_ō+]
	@param[in] ui_vertical_origin XvCgY\Wn[0:[_ŉ+][1:S_ŏ+][2:E[_ŉ+]
	@param[in] b_stretch_h C[̘_TCYɍ킹āA`C[Wgk
	@param[in] b_stretch_v C[̘_TCYɍ킹āA`C[Wgk
	@param[in] b_saturation Zs
	@param[in] b_aa A`GCAXs
	@param[in] f_view_scale `g嗦
*/
__declspec(dllexport) RESULT CreateTofuSprite(
	  SP_ID& ret_sprite_id
	, TOFU_SPRITE_TYPE type
	, SBTE_UID layer_name
	, UINT32 ui_priority
	, UINT32 ui_horizontal_origin
	, UINT32 ui_vertical_origin
	, BOOL b_stretch_h
	, BOOL b_stretch_v
	, BOOL b_saturation
	, BOOL b_aa
	, float f_view_scale = 1.0f
	);

// --------------------------------------------------------------------------
// XvCgnFXvCgAGMXvCgʑ
// --------------------------------------------------------------------------
//! XvCgFL
/*!
	@param[in] sprite_id XvCgID
	@param[in] b_enable Lɂ邩̒l
	@param[in] thread_index (\)0w肷
*/

__declspec(dllexport) RESULT SP_SetEnable( SP_ID sprite_id , BOOL b_enable , UINT32 thread_index = 0 );
//! GMXvCgFL
/*!
	@param[in] sprite_id GMXvCgID
	@param[in] b_enable Lɂ邩̒l
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT GMSP_SetEnable( GMSP_ID sprite_id , BOOL b_enable , UINT32 thread_index = 0 );


//! XvCgF
/*!
	@param[in] sprite_id XvCgID
	@param[in] b_visible \邩̒l
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT SP_SetVisible( SP_ID sprite_id , BOOL b_visible , UINT32 thread_index = 0 );

//! GMXvCgF
/*!
	@param[in] sprite_id GMXvCgID
	@param[in] b_visible \邩̒l
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT GMSP_SetVisible( GMSP_ID sprite_id , BOOL b_visible , UINT32 thread_index = 0 );


//! XvCgFړ
/*!
	@param[in] sprite_id XvCgID
	@param[in] pv2_position ړW
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT SP_SetPositioning( SP_ID sprite_id , const float* pv2_position , UINT32 thread_index = 0 );

//!	GMXvCgFړ
/*!
	@param[in] sprite_id GMXvCgID
	@param[in] pv2_position ړW
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT GMSP_SetPositioning( GMSP_ID sprite_id , const float* pv2_position , UINT32 thread_index = 0 );


//! XvCgFgk
/*!
	@param[in] sprite_id XvCgID
	@param[in] f_scale_x g嗦
	@param[in] f_scale_y cg嗦
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT SP_SetScaling( SP_ID sprite_id , float f_scale_x , float f_scale_y , UINT32 thread_index = 0 );

//! GMXvCgFgk
/*!
	@param[in] sprite_id GMXvCgID
	@param[in] f_scale_x g嗦
	@param[in] f_scale_y cg嗦
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT GMSP_SetScaling( GMSP_ID sprite_id , float f_scale_x , float f_scale_y , UINT32 thread_index = 0 );


//! XvCgF]
/*!
	@param[in] sprite_id XvCgID
	@param[in] f_rotate ]px[rad]
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT SP_SetRotation( SP_ID sprite_id , float f_rotate , UINT32 thread_index = 0 );

//! GMXvCgF]
/*!
	@param[in] sprite_id GMXvCgID
	@param[in] f_rotate ]px[rad]
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT GMSP_SetRotation( GMSP_ID sprite_id , float f_rotate , UINT32 thread_index = 0 );


//! XvCgFDxύX
/*!
	@param[in] sprite_id XvCgID
	@param[in] ui_priority DxlA傫قǏɕ`悳B0xfffff(20bit)ől
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT SP_SetPriority( SP_ID sprite_id , UINT32 ui_priority , UINT32 thread_index = 0 );

//! GMXvCgFDxύX
/*!
	@param[in] sprite_id GMXvCgID
	@param[in] ui_priority DxlA傫قǏɕ`悳B0xfffff(20bit)ől
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT GMSP_SetPriority( GMSP_ID sprite_id , UINT32 ui_priority , UINT32 thread_index = 0 );


//! XvCgFuhFݒ
/*!
	@param[in] sprite_id XvCgID
	@param[in] ui_color J[lB32bit(ARGB)
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT SP_SetColor( SP_ID sprite_id , UINT32 ui_color , UINT32 thread_index = 0 );

//! GMXvCgFuhFݒ
/*!
	@param[in] sprite_id GMXvCgID
	@param[in] ui_color J[lB32bit(ARGB)
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT GMSP_SetColor( GMSP_ID sprite_id , UINT32 ui_color , UINT32 thread_index = 0 );


//! XvCgFړAgkA]ꊇw
/*!
	@param[in] sprite_id XvCgID
	@param[in] pv2_position ړW
	@param[in] f_scale_x g嗦
	@param[in] f_scale_y cg嗦
	@param[in] f_rotate ]px[rad]
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT SP_SetPosScalRot( SP_ID sprite_id , const float* pv2_position , float f_scale_x , float f_scale_y , float f_rotate , UINT32 thread_index = 0 );

//! GMXvCgFړAgkA]ꊇw
/*!
	@param[in] sprite_id GMXvCgID
	@param[in] pv2_position ړW
	@param[in] f_scale_x g嗦
	@param[in] f_scale_y cg嗦
	@param[in] f_rotate ]px[rad]
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT GMSP_SetPosScalRot( GMSP_ID sprite_id , const float* pv2_position , float f_scale_x , float f_scale_y , float f_rotate , UINT32 thread_index = 0 );


//! XvCgFJփA^b`
/*!
	@param[in] sprite_id XvCgID
	@param[in] camera_id A^b`JID
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT SP_SetCamera( SP_ID sprite_id , CAMERA_ID camera_id , UINT32 thread_index = 0 );

//! GMXvCgFJփA^b`
/*!
	@param[in] sprite_id GMXvCgID
	@param[in] camera_id A^b`JID
*/
__declspec(dllexport) RESULT GMSP_SetCamera( GMSP_ID sprite_id , CAMERA_ID camera_id );


// --------------------------------------------------------------------------
// XvCgnFXvCgp
// --------------------------------------------------------------------------
//! XvCgFUVAj[V̕\R}ݒ
/*!
	@param[in] sprite_id XvCgID
	@param[in] ui_animation_num ݒ肷R}ʒu
	@param[in] b_reverse Aj[VtĐ
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT SP_SetAnimation( SP_ID sprite_id , UINT32 ui_animation_num , BOOL b_reverse , UINT32 thread_index = 0 );

//! XvCgFsUVAj[VRowlw
/*!
	@param[in] sprite_id XvCgID
	@param[in] ui_animation_row sUVAj[VRowl
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT SP_SetMatrixAnimation( SP_ID sprite_id , UINT32 ui_animation_row , UINT32 thread_index = 0 );

//! XvCgF؂蔲`̐ݒi]XvCĝ݁j
/*!
	@param[in] sprite_id XvCgID
	@param[in] pv2_plt ؂蔲`̍W
	@param[in] pv2_volume ؂蔲TCY
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT SP_Scissoring( SP_ID sprite_id , const float* pv2_plt , const float* pv2_volume , UINT32 thread_index = 0 );


// --------------------------------------------------------------------------
// XvCgnFGMXvCgp
// --------------------------------------------------------------------------
//! GMXvCgF[Vw
/*!
	@param[in] sprite_id GMXvCgID
	@param[in] motion_name [VID
	@param[in] begin_frame Jnt[ʒu
	@param[in] ip_frame ݂̃t[̕ԃt[
	@param[in] b_play_motion [VĐJn
	@param[in] b_play_reverse (\)FALSEw肷
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT GMSP_SetMotion( GMSP_ID sprite_id , SBTE_UID motion_name , UINT32 begin_frame , UINT32 ip_frame , BOOL b_play_motion = TRUE , BOOL b_play_reverse = FALSE , UINT32 thread_index = 0 );

//! GMXvCgFR{[Vw
/*!
	@param[in] sprite_id GMXvCgID
	@param[in] combo_motion_name R{[VID
	@param[in] begin_frame Jnt[ʒu
	@param[in] ip_frame ݂̃t[̕ԃt[
	@param[in] b_play_motion [VĐJn
	@param[in] b_play_reverse (\)FALSEw肷
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT GMSP_SetComboMotion( GMSP_ID sprite_id , SBTE_UID combo_motion_name , UINT32 begin_frame , UINT32 ip_frame , BOOL b_play_motion = TRUE , BOOL b_play_reverse = FALSE , UINT32 thread_index = 0 );

//! GMXvCgF[VĐw(tĐ͌@\Ȃ)
/*!
	@param[in] sprite_id GMXvCgID
	@param[in] b_play_motion [VĐ邩̒l
	@param[in] b_play_reverse (\)FALSEw肷
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT GMSP_SetMotionPlayFlags( GMSP_ID sprite_id , BOOL b_play_motion , BOOL b_play_reverse , UINT32 thread_index = 0 );

//! GMXvCgF\ݒ
/*!
	@param[in] sprite_id GMXvCgID
	@param[in] b_force_saturation SẴp[cIɉZŕ`悷
	@param[in] b_force_alpha SẴp[cIɃŕ`悷
	@param[in] b_force_aa SẴp[cIɃA`GCAXONŕ`悷
	@param[in] b_force_no_aa SẴp[cIɃA`GCAXOFFŕ`悷
	@param[in] b_reverse_h SẴp[cIɐ]
	@param[in] b_reverse_v SẴp[cIɐ]
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT GMSP_SetRenderSetting( GMSP_ID sprite_id , BOOL b_force_saturation , BOOL b_force_alpha , BOOL b_force_aa , BOOL b_force_no_aa , BOOL b_reverse_h , BOOL b_reverse_v , UINT32 thread_index = 0 );

//! GMXvCgFRW̐ݒ
/*!
	RWLƂ邩ǂݒ肵܂BLȃRŴ݂vZAGMSP_GetCalcedCollisions()Ŏ擾\ƂȂ܂B

	@param[in] sprite_id GMXvCgID
	@param[in] b_enable_collisions RW̗LݒB
	@param[in] b_force_calc ȃRWłĂKvZAGMSP_GetCalcedCollisions()Ŏ擾ł悤ɂB
	@param[in] thread_index (\)0w肷

	@note ʏ햳ȃRWib_enable_collisionsݒlA[VݒAp[cݒ肩ʃRW̃L[t[ݒ܂ŕ̃tOANDFALSEƂȂRWj
	̌vZƎ擾͍s܂񂪁Ab_force_calcTRUȄꍇ͕KSẴRWvZA擾悤ɂȂ܂B
*/
__declspec(dllexport) RESULT GMSP_SetCollisionSetting( GMSP_ID sprite_id , BOOL b_enable_collisions , BOOL b_force_calc = FALSE , UINT32 thread_index = 0 );

// --------------------------------------------------------------------------
// GMXvCgp[^擾Aݒn
// ̍̊֐͂얢mF
// --------------------------------------------------------------------------
//! ݂̃[hW𓾂B
/*!
	@param[out] pv16_ret_mat_world 擾[hs
	@param[in] gmsp_id GMXvCgID
*/
__declspec(dllexport) RESULT GMSP_GetWorldMatrix( float* pv16_ret_mat_world , GMSP_ID gmsp_id );

//! ݂̎ṕAp[c̃[hW𓾂
/*!
	@param[out] pv16_ret_mat_world 擾p[c̃[hs
	@param[in] gmsp_id GMXvCgID
	@param[in] parts_id Ώۃp[cID
*/
__declspec(dllexport) RESULT GMSP_GetBoneWorldMatrix( float* pv16_ret_mat_world , GMSP_ID gmsp_id , SBTE_UID parts_id );

//! ݂̃[Ṽt[l𓾂
/*!
	@param[in] gmsp_id GMXvCgID

	@return t[ʒu
*/
__declspec(dllexport) UINT32 GMSP_GetCurrentMotionFrame( GMSP_ID gmsp_id );

//! ݂̃[V̎Ԃƍőt[l𓾂
/*!
	@param[out] ret_mot_time ݂̃[Voߎ[sec]
	@param[out] ret_max_mot_time ݂̃[V̍ő厞[sec]
	@param[out] ret_max_mot_frame ݂̃[V̍őt[
	@param[in] gmsp_id GMXvCgID
*/
__declspec(dllexport) RESULT GMSP_GetCurrentMotionMaxParams( float& ret_mot_time , float& ret_max_mot_time , UINT32& ret_max_mot_frame , GMSP_ID gmsp_id );

//! ݂̎p̃RWp[^̐擾
/*!
	@param[in] gmsp_id GMXvCgID
	@return RWԂB
*/
__declspec(dllexport) UINT32 GMSP_GetCalcedCollisionCount( GMSP_ID gmsp_id );

//! ݂̎p̃RWp[^擾AW̓[hl
/*!
	@param[out] ret_collisions 擾RWi[z
	@param[in] array_size ret_collisions̔zTCY(ڐ)B
	@param[in] gmsp_id GMXvCgID

	@par 擾RWɂ
	ret_collisions̍ڐGMSP_GetCalcedCollisionCount()ȏłKv܂B
	܂array_sizeɂ͂̒lݒ肵܂B@n
	݂̃[VAt[ɖȃRW܂܂ꍇA擾łRWf[^
	array_sizeȂȂ܂BۂɎ擾łLȃRW͖̐߂lƂĕԂ܂B
*/
__declspec(dllexport) UINT32 GMSP_GetCalcedCollisions( GMSP_CALCED_COLLISION_PARAMS* pa_ret_collisions , UINT32 array_size , GMSP_ID gmsp_id );

//! p[c̃[JW㏑B(GMSP_UpdateMotionFrame()CalcGMSP()̊ԂŎsKv)
/*!
	@param[in] gmsp_id GMXvCgID
	@param[in] parts_id p[cID
	@param[in] pv16_mat_local ㏑p̍s
*/
__declspec(dllexport) RESULT GMSP_OverwriteGMSPBoneLocalMatrix( GMSP_ID gmsp_id , SBTE_UID parts_id , const float* pv16_mat_local );

//! [VĐǂ𒲂ׂ
/*!
	@param[in] gmsp_id GMXvCgID

	@return ĐȂTRUEԂ
*/
__declspec(dllexport) BOOL GMSP_IsMotionPlaying( GMSP_ID gmsp_id );

//! w肵p[c̃C[Wp[^擾
/*!
	@param[in] gmsp_id GMXvCgID
	@param[in] parts_id p[cID

*/
__declspec(dllexport) RESULT GMSP_GetPartsImageParams( GMSP_PARTS_IMAGE_PARAMS& ret_params , GMSP_ID gmsp_id , SBTE_UID parts_id );

//! w肵p[c̃C[Wp[^㏑
/*!
	GMSP_Calc()̌ŌĂԂƂŁAp[c̕\Ԃ㏑܂B@n
	(Fj󂳂ꂽp[cȂ)

	@param[in] gmsp_id GMXvCgID
	@param[in] parts_id p[cID


	@return ĐȂTRUEԂ
*/
__declspec(dllexport) RESULT GMSP_OverwritePartsImageParams( GMSP_ID gmsp_id , SBTE_UID parts_id , const GMSP_PARTS_IMAGE_PARAMS& params );


// --------------------------------------------------------------------------
// GMXvCgXVn
// --------------------------------------------------------------------------
//! [Ṽt[XV
/*!
	@param[in] gmsp_id GMXvCgID
	@param[in] f_elapsed_time oߎ[sec]
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT GMSP_UpdateMotionFrame( GMSP_ID gmsp_id , float f_elapsed_time , UINT32 thread_index = 0 );

//! XVꂽt[ɊÂāAp[c̍WvZB
/*!
	@param[in] gmsp_id GMXvCgID
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT GMSP_Calc( GMSP_ID gmsp_id , UINT32 thread_index = 0 );

// --------------------------------------------------------------------------
// XvCgJ֘A
// --------------------------------------------------------------------------
//! Jǉ
/*!
	@param[in] ret_camera_id ǉJID
	@param[in] pstr_camera_name ǉJ̖O
*/
__declspec(dllexport) RESULT AddGMSPCamera( SBTE_UID& ret_camera_id , const SBTE_CHAR* pstr_camera_name );

//! Jp[^XV
/*!
	@param[in] camera_id JID
	@param[in] pv2_pos 
	@param[in] f_zoom 
*/
__declspec(dllexport) RESULT SetGMSPCameraParams( SBTE_UID camera_id , const float* pv2_pos , float f_zoom );

//! J폜
/*!
	@param[in] camera_id JID
*/
__declspec(dllexport) RESULT RemoveGMSPCamera( SBTE_UID camera_id );

//! J̍W𓾂 
/*!
	@param[out] pv16_ret_mat 擾Js
	@param[in] camera_id JID
*/
__declspec(dllexport) RESULT GetGMSPCameraMatrix( float* pv16_ret_mat , SBTE_UID camera_id );

// --------------------------------------------------------------------------
// XvCg֘A
// --------------------------------------------------------------------------
//! Đݒ肷
/*!
	@param[in] sp_id XvCgID
	@param[in] p_string Đݒ肷镶
	@param[in] ui_length 
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT SP_InscriptionString( SP_ID sp_id , const WCHAR* p_string , UINT32 ui_length , UINT32 ui_line_index = 0 );

//! ̌ʕ̐Fݒ肷
/*!
	b_bg = TRUEō쐬́AƂɔwiFݒ肷邱Ƃł܂B@n
	SP_SetColor()gƁASĂ̕PFAwi𓧖ɐݒ肵܂B

	@param[in] sp_id XvCgID
	@param[in] ui_glyph_coloring F
	@param[in] ui_bg_coloring wiF
	@param[in] ui_glyph_begin_number Ftŏ̈̕ʒu
	@param[in] ui_glyph_count Ft镶B߂Ă͖̂ŁAUINT_MAXw肷Ζ܂œKp܂B
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT SP_GlyphColoring( SP_ID sp_id , UINT32 ui_glyph_coloring , UINT32 ui_bg_coloring , UINT32 ui_glyph_begin_number , UINT32 glyph_count , UINT32 ui_line_index = 0 );

//! XvCgŜ̃TCY擾
/*!
	SetSprite_InscriptionString()s͕XVsĂȂ߁AÂlԂ܂B@n
	UpdateSBTE()sɐVlԂ܂B

	@param[in] sp_id XvCgID
	@param[out] ui_ret_width XvCg̕
	@param[out] ui_ret_height XvCg̍
*/
__declspec(dllexport) RESULT SP_GetInscriptionSize( SP_ID sp_id , UINT32& ui_ret_width , UINT32& ui_ret_height );


// --------------------------------------------------------------------------
// v~eBuXvCg֘A
// --------------------------------------------------------------------------
//! v~eBuXvCg̊e_ʒuݒ肷
/*!
	_XvCg̏ꍇAP_̍Wɓ_`@n
	XvCg̏ꍇAP_`Q_Ԃɐ`@n
	`XvCg̏ꍇAP_`S_ԂɎlp``B`łȂĂǂA_̕тTriangleStrip^

	@param[in] sp_id XvCgID
	@param[in] pv2_pos0 P_
	@param[in] pv2_pos1 Q_
	@param[in] pv2_pos2 R_
	@param[in] pv2_pos3 S_
	@param[in] thread_index (\)0w肷
*/
__declspec(dllexport) RESULT SP_TofuPts( SP_ID sp_id , const float* pv2_pos0 , const float* pv2_pos1 , const float* pv2_pos2 , const float* pv2_pos3 , UINT32 ui_line_index = 0 );


// --------------------------------------------------------------------------
// ̑
// --------------------------------------------------------------------------
//! MEMORY_ID|C^ɕϊ
/*!
	@param[in] memory_id ϊ郁ID
	@return ϊ̃|C^
*/
__declspec(dllexport) void* GetMemoryPointer( MEMORY_ID memory_id );


// --------------------------------------------------------------------------

}; // namespace SBTE

