// --------------------------------------------------------------------------
// ʏ

#include "stdafx.h"

#include "Strsafe.h"				// StringCbPrintfW()p
#include "SBTESample.h"

// --------------------------------------------------------------------------
// ϐ

// extern̎
SBTE::SBTE_UID	LayerID				= 0;
LPDIRECT3DDEVICE9 pd3ddev			= NULL;



// XvCg`ID
static SBTE::SPDEF_ID	TestSpriteDefineID1	= 0;
static SBTE::SPDEF_ID	TestSpriteDefineID2	= 0;
static SBTE::SPDEF_ID	TestSpriteDefineID3	= 0;
static SBTE::SPDEF_ID	TestGMSPDefine1		= 0;

// XvCgID
static SBTE::SBTE_UID	TestSprite_01		= 0;
static SBTE::SBTE_UID	TestSprite_02		= 0;
static SBTE::SBTE_UID	TestSprite_03		= 0;
static SBTE::SBTE_UID	TestGMSprite_01		= 0;
static SBTE::SBTE_UID	TestCamera			= 0;
static SBTE::SBTE_UID	TestString			= 0;
static SBTE::SBTE_UID	TestPrimitive		= 0;

// tHg
static HFONT			hTestFont			= NULL;

// gpQ[pbhID
static UINT32			ControllerID		= 0;

// gpQ[pbh̃ZID
static UINT32			CellID_X			= 0;	// X
static UINT32			CellID_Y			= 0;	// Y
static UINT32			CellID_A			= 0;	// A{^
static UINT32			CellID_B			= 0;	// B{^
static UINT32			CellID_C			= 0;	// C{^
static UINT32			CellID_D			= 0;	// D{^


// --------------------------------------------------------------------------
// ֐錾
void ReleaseSprites( void );


// --------------------------------------------------------------------------
// ُI
void ErrorFinalize( void )
{
#if USING_SBTE_INPUT
	SBTE::ReleaseInputDevices();
#endif
	SBTE::RemoveLayer( LayerID );
	SBTE::ReleaseSBTE();

#if USING_DXLIB
	DXLibFinalize();
#endif
}

// --------------------------------------------------------------------------
// I
void Finalize( BOOL b_output_sprite_temp_texture , BOOL b_output_layer_texture )
{
	ReleaseSprites();
	SBTE::DeleteTimer();

	// XvCgƃeNX`̗p󋵂o
	SBTE::ReportSprites( b_output_sprite_temp_texture );
	SBTE::ReportTextures();
	SBTE::ReportLayers();
	if ( b_output_layer_texture )
	{
		SBTE::SaveLayerImage( LayerID , LAYER_SAVE_NAME );
	}
	SBTE::ReportScreens();

	SBTE::ReleaseFont( hTestFont );

	SBTE::RemoveGMSPCamera( TestCamera );
	SBTE::RemoveLayer( LayerID );

#if USING_SBTE_INPUT
	SBTE::ReleaseInputDevices();
#endif

	SBTE::ReleaseSBTE();

#if USING_DXLIB
	DXLibFinalize();
#endif

}


// --------------------------------------------------------------------------
// `pC[̐ݒ
void MakeLayerParams( SBTE::LAYER_PARAMS& ret_layer_params )
{
	// GW̕`惌C[̃p[^
	ret_layer_params.pName				= LAYER_NAME;
	ret_layer_params.pAliasName			= NULL;
	ret_layer_params.ScreenID			= 0;

	ret_layer_params.ColorFormat		= D3DFMT_A8R8G8B8;		// _O^[Qbg̃tH[}bg
	ret_layer_params.bEnableDepthBuffer	= FALSE;
	ret_layer_params.DepthFormat		= D3DFMT_D24S8;		// 
	ret_layer_params.LayerWidth			= WINDOW_WIDTH;			// C[̃TCY
	ret_layer_params.LayerHeight		= WINDOW_HEIGHT;
	ret_layer_params.ReserveWidth		= 0;					// C[̊mۃTCY : DirectXȂ2^n
	ret_layer_params.ReserveHeight		= 0;
	ret_layer_params.LogicalWidth		= LOGICAL_WIDTH;			// XvCgp_TCY
	ret_layer_params.LogicalHeight		= LOGICAL_HEIGHT;
	ret_layer_params.ScreenDrawPosX		= 0;					// XN[̓]`
	ret_layer_params.ScreenDrawPosY		= 0;
	ret_layer_params.ScreenDrawWidth	= WINDOW_WIDTH;
	ret_layer_params.ScreenDrawHeight	= WINDOW_HEIGHT;

	ret_layer_params.Priority			= 0;
	ret_layer_params.ClearColor			= 0xff000000;
	ret_layer_params.fClearZ			= 1.0f;
	ret_layer_params.bClearColor		= TRUE;
	ret_layer_params.bClearZ			= FALSE;

	ret_layer_params.pfuncInitialize	= LayerCallBack_Main_Initialize;			// C[̏ɌĂ΂
	ret_layer_params.pfuncPreRender		= LayerCallBack_Main_PreRender;				// BeginSceneɌĂ΂
	ret_layer_params.pfuncPreEffect		= NULL;										// PreRenderANAOɌĂ΂BNULLɐݒAFALSEԂƁAC[NA
	ret_layer_params.pfuncActivate		= NULL;										// C[Activate()ƂɌĂ΂
	ret_layer_params.pfuncPostRender	= NULL;			// obNobt@ւ̓]ʒOɍsBFALSEԂƁA]ʂLZ
	ret_layer_params.pfuncRelease		= LayerCallBack_Main_Release;				// C[̍폜ɌĂ΂
	ret_layer_params.pfuncPreResize		= LayerCallBack_Main_PreResize;
	ret_layer_params.pfuncPostResize	= LayerCallBack_Main_PostResize;

	return;
}

// --------------------------------------------------------------------------
// ̓foCX
BOOL InitializeInputDevices( HINSTANCE h_instance , HWND h_wnd )
{
	// ̓foCX̏
	SBTE::INPUT_DEVICE_ENUM_MINIMUM_CAPS caps;
	caps.bEnableKeyboard						= TRUE;		//!< L[{[hgp
	caps.bEnableMouse							= FALSE;	//!< }EXgp
	caps.bEnableGameController					= TRUE;		//!< Q[Rg[[gp
	caps.dwMinimumKeyboardButtonNumber			= 0;		//!< gpL[{[h̍Œ{^
	caps.dwMinimumMouseAxisNumber				= 0;		//!< gp}EX̍ŒᎲ
	caps.dwMinimumMouseButtonNumber				= 0;		//!< gp}EX̍Œ{^
	caps.dwMinimumGameControllerAxisNumber		= 2;		//!< gpQ[Rg[[̍Œgp
	caps.dwMinimumGameControllerButtonNumber	= 2;		//!< gpQ[Rg[[̍Œgp{^
	caps.dwMinimumGameControllerPovNumber		= 0;		//!< gpQ[Rg[[̍ŒgpPov

	if ( !h_instance )
	{
		h_instance = SBTE::GetInstanceHandle();
	}
	if ( !h_wnd )
	{
		h_wnd = SBTE::GetWindowHandle();
	}

	SBTE::RESULT res = SBTE::InitializeInputDevices( caps , h_instance , h_wnd );
	if ( res != SBTE::RESULT::RESULT__SUCCEEDED )
	{
		return FALSE;
	}

	// ̓foCX̎擾
	UINT32 keyboard_ct = 0;
	UINT32 controller_ct = 0;
	UINT32 a_controller_ids[8] = {0};
	res = SBTE::GetControllers( keyboard_ct , controller_ct , a_controller_ids , 8 );
	if ( res != SBTE::RESULT::RESULT__SUCCEEDED )
	{
		SBTE::ReleaseInputDevices();
		return FALSE;
	}

	// Rg[[0gp
	if ( controller_ct > 0 )
	{
		ControllerID = a_controller_ids[0];
		SBTE::SBTE_CHAR dev_name[1024];
		SBTE::GetDeviceName( dev_name , 1000 , ControllerID );

		// Z̗
		vector< UINT32 > a_axis_x;
		vector< UINT32 > a_axis_y;
		vector< UINT32 > a_axis_z;
		vector< UINT32 > a_axis_o;
		vector< UINT32 > a_buttons;
		vector< UINT32 > a_povs;

		// Rg[[̃Z̐擾
		UINT32 axct = 0;
		UINT32 ayct = 0;
		UINT32 azct = 0;
		UINT32 aoct = 0;
		UINT32 bct = 0;
		UINT32 pvct = 0;
		SBTE::GetControllerCellCount( axct , ayct , azct , aoct , bct , pvct , ControllerID );

		// Rg[[̃ZID擾
		a_axis_x.resize( axct );
		a_axis_y.resize( ayct );
		a_axis_z.resize( azct );
		a_axis_o.resize( aoct );
		a_buttons.resize( bct );
		a_povs.resize( pvct );
		SBTE::GetControllerCells(	  axct ? &(a_axis_x[0]) : NULL
									, ayct ? &(a_axis_y[0]) : NULL
									, azct ? &(a_axis_z[0]) : NULL
									, aoct ? &(a_axis_o[0]) : NULL
									, bct ? &(a_buttons[0]) : NULL
									, pvct ? &(a_povs[0]) : NULL , ControllerID );

		// XYA{^Rg[[̏ꍇAgp~
		if ( a_axis_x.empty() )
		{
			ControllerID = 0;
		}

		if ( a_axis_y.empty() )
		{
			ControllerID = 0;
		}

		if ( a_buttons.empty() )
		{
			ControllerID = 0;
		}

		if ( ControllerID != 0 )
		{
			CellID_X = a_axis_x[0];
			CellID_Y = a_axis_y[0];
			CellID_A = a_buttons[0];
			if ( a_buttons.size() >= 1 ) CellID_B = a_buttons[1];
			if ( a_buttons.size() >= 1 ) CellID_C = a_buttons[2];
			if ( a_buttons.size() >= 1 ) CellID_D = a_buttons[3];

			char s[1024];
			sprintf_s(s,1000 , "Rg[[ %s gp X(%d) Y(%d) BtnA(%d)\r\n" , dev_name , CellID_X , CellID_Y , CellID_A );
			OutputDebugStringA(s);
		}
		else
		{
			char s[1024];
			sprintf_s(s,1000 , "Rg[[ %s ͔\͕sɂgpł܂ X(ct:%d) Y(ct:%d) Btn(ct:%d)\r\n" , dev_name , CellID_X , CellID_Y , CellID_A );
			OutputDebugStringA(s);
		}
	}

	return TRUE;
}

// --------------------------------------------------------------------------
// Av̏ݒ
BOOL AppSetup( void )
{
	// XvCg\[X[hĒ`쐬
	{
#if 1
		SBTE::SPRITE_DEFINE_PARAMS params;
		params.Priority							= 100;
		params.bAnimation						= FALSE;
		params.bStretchH						= TRUE;
		params.bStretchV						= TRUE;
		params.bCenterPoint						= TRUE;
		params.pstrImagePath					= (char*)("Data\\SingleImages\\TestSP1.png");
		params.HorizontalOrigin					= 1;
		params.VerticalOrigin					= 1;
		params.bAutoAnimation					= FALSE;
		params.bAutoLoop						= FALSE;
		params.bMatrixAnimation					= FALSE;
		params.fAutoStep						= 0.0f;
		params.AnimationCount					= 0;
		params.AnimationChipWidth				= 0;
		params.AnimationChipHeight				= 0;
		params.bSaturation						= FALSE;
		params.bAntiAlias						= FALSE;
		params.bReverseH						= FALSE;
		params.bReverseV						= FALSE;
		if ( SBTE_FAILED( SBTE::CreateSpriteDefine( "TestSprite" , params , NULL , &TestSpriteDefineID1 ) ) )
		{
			ErrorFinalize();
			return FALSE;
		}

		params.Priority							= 110;
		params.bAnimation						= FALSE;
		params.bStretchH						= TRUE;
		params.bStretchV						= TRUE;
		params.bCenterPoint						= TRUE;
		params.pstrImagePath					= (char*)("Data\\SingleImages\\TestSP2.png");
		params.VerticalOrigin					= 1;
		params.HorizontalOrigin					= 1;
		params.bAutoAnimation					= FALSE;
		params.bAutoLoop						= FALSE;
		params.bMatrixAnimation					= FALSE;
		params.fAutoStep						= 0.0f;
		params.AnimationCount					= 0;
		params.AnimationChipWidth				= 0;
		params.AnimationChipHeight				= 0;
		params.bSaturation						= FALSE;
		params.bAntiAlias						= FALSE;
		params.bReverseH						= FALSE;
		params.bReverseV						= FALSE;
		if ( SBTE_FAILED( SBTE::CreateSpriteDefine( "TestSprite2" , params , NULL , &TestSpriteDefineID2 ) ) )
		{
			ErrorFinalize();
			return FALSE;
		}

		params.Priority							= 200;
		params.bAnimation						= FALSE;
		params.bStretchH						= TRUE;
		params.bStretchV						= TRUE;
		params.bCenterPoint						= TRUE;
		params.pstrImagePath					= (char*)("Data\\SingleImages\\TestSP3.png");
		params.VerticalOrigin					= 1;
		params.HorizontalOrigin					= 1;
		params.bAutoAnimation					= FALSE;
		params.bAutoLoop						= FALSE;
		params.bMatrixAnimation					= FALSE;
		params.fAutoStep						= 0.0f;
		params.AnimationCount					= 0;
		params.AnimationChipWidth				= 0;
		params.AnimationChipHeight				= 0;
		params.bSaturation						= FALSE;
		params.bAntiAlias						= FALSE;
		params.bReverseH						= FALSE;
		params.bReverseV						= FALSE;
		if ( SBTE_FAILED( SBTE::CreateSpriteDefine( "TestSprite3" , params , NULL , &TestSpriteDefineID3 ) ) )
		{
			ErrorFinalize();
			return FALSE;
		}
#endif
		// GMXvCgsample2`[h
//		if ( SBTE_FAILED( SBTE::LoadGMSpriteDefine( "set1/sample2" , "Data\\GMSPs\\sample2\\sample2.gsb" , "Data\\GMSPs\\sample2\\sample2.gmb" , 0 , &TestGMSPDefine1 ) ) )	// P̂Ń[hꍇ
		if ( SBTE_FAILED( SBTE::LoadGMSpriteDefines( "Data\\GMSPs\\set1.gmpset" , "set1" ) ) ) // ꊇ[ht@CŃ[hꍇ
		{
			ErrorFinalize();
			return FALSE;
		}

		// tHg쐬
		SBTE::FONT_PARAMS fp;

		fp.uiHeight		= 24;
		fp.uiWeight		= 1000;
		fp.bItalic		= FALSE;
		fp.bUnderLine	= FALSE;
		fp.bStrikeOut	= FALSE;
		fp.uiFixedPitch	= 28;
		fp.bAA			= TRUE;
		fp.uiDefaultCRYStep = 28;
//		fp.pstrFontName	= "CI";
		fp.pstrFontName	= "lr SVbN";
		if ( SBTE_FAILED( SBTE::CreateFont( hTestFont , fp ) ) )
		{
			ErrorFinalize();
			return FALSE;
		}

		// obt@XV
		SBTE::RefreshSpriteDefine();
	}

	srand(1);

	return TRUE;
}

// P̃XvCg̃Xe[g
struct TestSpriteTask
{
	float x;
	float y;
	float vx;
	float vy;
	float r;
	float vr;
	float s;
	float hit_interval;
	SBTE::SP_ID id;
};

static vector< TestSpriteTask* > aSpriteTasks;

const int SPRITE_COUNT = 64;

// GMSPXvCg̏
static D3DXVECTOR2	vGMSPPos;
static float		GMSPActionInterval = 0.0f;
static float		fXAxis = 0.0f;
static float		fYAxis = 0.0f;
static UINT32		DigitalAxis = 0;
const float			MOVE_SPEED = 500.0f;
const float			CAMERA_ZOOM = 0.5f;

// XRA\
static UINT32 Score = 0;
static WCHAR TextString01[1024] = L"\
XRA:%5d\r\n\
c  :%5d\r\n\
J[\/\ :ړ\r\n\
X/{^      :\
";




BOOL CreateSprites( void )
{
	// GMSP sample2쐬
	
	float pos[2] = {0.0f,0.0f};
	float camera_pos[2] = {0.0f,0.0f};
	float camera_zoom = CAMERA_ZOOM;
	{
		SBTE::CreateGMSprite( TestGMSprite_01 , "set1/sample2" , LayerID );

		SBTE::GMSP_SetEnable( TestGMSprite_01 , TRUE );
		SBTE::GMSP_SetVisible( TestGMSprite_01 , TRUE );
		SBTE::GMSP_SetPriority( TestGMSprite_01 , 13 );
		SBTE::GMSP_SetPosScalRot( TestGMSprite_01 , pos , 1.0f , 1.0f , 0.0f );
		SBTE::GMSP_SetRotation( TestGMSprite_01 , 0.125f );

		SBTE::AddGMSPCamera( TestCamera , "Main" );
		SBTE::SetGMSPCameraParams( TestCamera , camera_pos , camera_zoom );

		SBTE::GMSP_SetCamera( TestGMSprite_01 , TestCamera );
//		SBTE::GMSP_SetComboMotion( TestGMSprite_01 , SBTE::GetResUID("Demo") , 0 , 0 );
		SBTE::GMSP_SetMotion( TestGMSprite_01 , SBTE::GetResUID("Idle") , 0 , 0 );
		SBTE::GMSP_SetMotionPlayFlags( TestGMSprite_01 , TRUE , FALSE );
		SBTE::GMSP_SetCollisionSetting( TestGMSprite_01 , TRUE , FALSE );


		vGMSPPos = D3DXVECTOR2( 0.0f , 0.0f );
		GMSPActionInterval = 0.0f;
		fXAxis = 0.0f;
		fYAxis = 0.0f;
		DigitalAxis = 0;

		Score = 0;
	}

	// XvCgw萔쐬
	{
		SBTE::SPDEF_ID defs[4] = { TestSpriteDefineID1 , TestSpriteDefineID2 , TestSpriteDefineID3 , TestSpriteDefineID1 };
		aSpriteTasks.clear();

		for ( UINT32 i = 0 ; i < SPRITE_COUNT ; ++i )
		{
			float x = static_cast<float>(((rand() & 0xff) - 128));
			float y = static_cast<float>(((rand() & 0xff) - 128));
			float vx = static_cast<float>(((rand() & 0xff) - 128));
			float vy = static_cast<float>(((rand() & 0xff) - 128));
			UINT32 type = (rand() & 0x3);
			UINT32 pri = (rand() & 0xf);
			float s = ((static_cast<float>(rand() & 0xff)) / 255.0f) + 0.5f;
			float r = ((static_cast<float>((rand() & 0xff) - 128)) / 128.0f) * 3.14159f * 2.0f;
			float vr = ((static_cast<float>((rand() & 0xff) - 128)) / 128.0f) * 3.14159f;


			SBTE::SP_ID id;
			float pos[2] = {x,y};

			SBTE::CreateSprite( id , defs[type] , LayerID );
			SBTE::SP_SetEnable( id , TRUE );
			SBTE::SP_SetVisible( id , TRUE );
			SBTE::SP_SetPriority( id , pri );
			SBTE::SP_SetPosScalRot( id , pos , s , s , r );

			SBTE::SP_SetCamera( id , TestCamera );

			aSpriteTasks.push_back( new TestSpriteTask() );
			aSpriteTasks.back()->x = x;
			aSpriteTasks.back()->y = y;
			aSpriteTasks.back()->vx = vx;
			aSpriteTasks.back()->vy = vy;
			aSpriteTasks.back()->r = r;
			aSpriteTasks.back()->vr = vr;
			aSpriteTasks.back()->s = s;
			aSpriteTasks.back()->id = id;
			aSpriteTasks.back()->hit_interval = 0.0f;
		}
	
	}
	
	// 
	{
		float pos[2] = {0,0};

		SBTE::CreateInscription( TestString
			, hTestFont
			, L""
			, LayerID
			, 100
			, 0
			, 0
			, FALSE
			, FALSE
			, FALSE
			, TRUE
			, FALSE
			, 0
			, 1.0f
			, TRUE
			, FALSE
			, FALSE
			, NULL
			);

		SBTE::SP_SetEnable( TestString , TRUE );
		SBTE::SP_SetVisible( TestString , TRUE );
		SBTE::SP_SetColor( TestString , 0xe0ffe0e0 );
		SBTE::SP_SetPositioning( TestString , pos );
	}

	// v~eBu
	{
		SBTE::CreateTofuSprite( TestPrimitive
			, SBTE::TOFU_SPRITE_TYPE_RECTANGLE
			, LayerID
			, 50
			, 0
			, 0
			, TRUE
			, TRUE
			, FALSE
			, FALSE
			, 1.0f
		);
		SBTE::SP_SetEnable( TestPrimitive , TRUE );
		SBTE::SP_SetVisible( TestPrimitive , TRUE );
		SBTE::SP_SetColor( TestPrimitive , 0xa0ffffff );

		float v[4*2] = {	0.0f	,	0.0f	,
							0.0f	,	0.0f	,
							0.0f	,	0.0f	,
							0.0f	,	0.0f
		};
		SBTE::SP_TofuPts( TestPrimitive , &v[0] , &v[2] , &v[4] , &v[6] , 0 );
	}

	return TRUE;
}

// --------------------------------------------------------------------------
// XvCg̍XV
void UpdateSprites( float elapsed_time )
{
//	elapsed_time = 0.016f;		// ꍇ͌Œ莞Ԃɂ

	static const float SPRITE_LIMIT_XP = static_cast<float>(LOGICAL_WIDTH/2) / CAMERA_ZOOM;
	static const float SPRITE_LIMIT_YP = static_cast<float>(LOGICAL_HEIGHT/2) / CAMERA_ZOOM;
	static const float SPRITE_LIMIT_XM = -static_cast<float>(LOGICAL_WIDTH/2) / CAMERA_ZOOM;
	static const float SPRITE_LIMIT_YM = -static_cast<float>(LOGICAL_HEIGHT/2) / CAMERA_ZOOM;

	// RW
	BOOL b_enable_apple_col = FALSE;
	D3DXVECTOR2 v_apple_col_pos = D3DXVECTOR2( 0.0f , 0.0f );
	float f_apple_radius = 0.0f;

	// sample2
	{
		// ͏
		BOOL b_button = FALSE;
		BOOL b_button_input = FALSE;
		float f_KB_X = 0.0f;
		float f_KB_Y = 0.0f;

#if USING_SBTE_INPUT

		SBTE::UpdateInputDevices( elapsed_time );

		// ̓O
		SBTE::INPUT_DEVICE_LOG dev_log;

		// OɂȂ܂œ͏Ɏ擾
		while ( GetNextInputDevicesLog( dev_log ) != SBTE::RESULT::RESULT__INPUT_LOG_IS_EMPTY )
		{
			// Q[pbh
			if ( dev_log.dwDeviceID == ControllerID )
			{
				// X̏
				if ( dev_log.dwCellID == CellID_X )
				{
					fXAxis = dev_log.fAnalogValue;
				}

				// Y̏
				if ( dev_log.dwCellID == CellID_Y )
				{
					// XvCg̍Wn̏+ɐݒ肵Ă̂ŁA͂𔽓]
					fYAxis = -dev_log.fAnalogValue;
				}

				// {^̏
				if ( dev_log.dwCellID == CellID_A )
				{
					b_button = (dev_log.dwDigitalValue == 1);
					b_button_input = TRUE;
				}
			}

			// L[{[h
			if ( dev_log.dwDeviceID == 0 )
			{
				// Y̏
				if ( dev_log.dwCellID == DIK_UP )
				{
					DigitalAxis &= 0xfe;
					if ( dev_log.dwDigitalValue )
					{
						DigitalAxis |= 0x01;
					}
				}
				if ( dev_log.dwCellID == DIK_DOWN )
				{
					DigitalAxis &= 0xfd;
					if ( dev_log.dwDigitalValue )
					{
						DigitalAxis |= 0x02;
					}
				}

				// X̏
				if ( dev_log.dwCellID == DIK_LEFT )
				{
					DigitalAxis &= 0xfb;
					if ( dev_log.dwDigitalValue )
					{
						DigitalAxis |= 0x04;
					}
				}
				if ( dev_log.dwCellID == DIK_RIGHT )
				{
					DigitalAxis &= 0xf7;
					if ( dev_log.dwDigitalValue )
					{
						DigitalAxis |= 0x08;
					}
				}

				// {^̏
				if ( dev_log.dwCellID == DIK_X )
				{
					b_button = (dev_log.dwDigitalValue == 1);
					b_button_input = TRUE;
				}
			}
		}
#else
		// DXLibɂ͏
		{
			DigitalAxis = 0;
			int state = GetJoypadInputState( DX_INPUT_KEY_PAD1 ) ;
			if ( state )
			{
				// Y̏
				if ( state & PAD_INPUT_UP )
				{
					DigitalAxis |= 0x01;
				}
				if ( state & PAD_INPUT_DOWN )
				{
					DigitalAxis |= 0x02;
				}
			
				// X̏
				if ( state & PAD_INPUT_LEFT )
				{
					DigitalAxis |= 0x04;
				}
				if ( state & PAD_INPUT_RIGHT )
				{
					DigitalAxis |= 0x08;
				}

				// {^̏
				if ( state & PAD_INPUT_1 )
				{
					b_button = TRUE;
					b_button_input = TRUE;
				}
			}
		}
#endif
		// fW^{^ϊ
		UINT32 axis = DigitalAxis & 0xf;
		static const float axis2move[32] = {	 0.0f ,  0.0f ,		// 
												 0.0f ,  1.0f ,		// U
												 0.0f , -1.0f ,		// D
												 0.0f ,  0.0f ,		// UD

												-1.0f ,  0.0f ,		// L
												-1.0f ,  1.0f ,		// LU
												-1.0f , -1.0f ,		// LD
												-1.0f ,  0.0f ,		// LUD

												 1.0f ,  0.0f ,		// R
												 1.0f ,  1.0f ,		// RU
												 1.0f , -1.0f ,		// RD
												 1.0f ,  0.0f ,		// RUD

												 0.0f ,  0.0f ,		// RL
												 0.0f ,  1.0f ,		// RLU
												 0.0f , -1.0f ,		// RLD
												 0.0f ,  0.0f		// RLUD
		};

		f_KB_X += axis2move[axis*2+0];
		f_KB_Y += axis2move[axis*2+1];

		// ړ
		D3DXVECTOR2 v_dir = D3DXVECTOR2( fXAxis + f_KB_X , fYAxis + f_KB_Y );
		D3DXVec2Normalize( &v_dir , &v_dir );
		vGMSPPos.x += v_dir.x * MOVE_SPEED * elapsed_time;
		vGMSPPos.y += v_dir.y * MOVE_SPEED * elapsed_time;

		// WFJY[lŕ\WnkĂ̂ŁA̕g傷B
		float lw = static_cast<float>(LOGICAL_WIDTH) / CAMERA_ZOOM;
		float lh = static_cast<float>(LOGICAL_HEIGHT) / CAMERA_ZOOM;

		if ( vGMSPPos.x < (-lw/2.0f) )	vGMSPPos.x = (-lw/2.0f);
		if ( vGMSPPos.x > (lw/2.0f) )	vGMSPPos.x = (lw/2.0f);
		if ( vGMSPPos.y < (-lh/2.0f) )	vGMSPPos.y = (-lh/2.0f);
		if ( vGMSPPos.y > (lh/2.0f) )	vGMSPPos.y = (lh/2.0f);

		// S
		if ( b_button && b_button_input && GMSPActionInterval > 1.0f )
		{
			SBTE::GMSP_SetMotion( TestGMSprite_01 , SBTE::GetResUID("Throw") , 0 , 2 );
			GMSPActionInterval = 0.0f;
		}

		// XV
		SBTE::GMSP_SetPosScalRot( TestGMSprite_01 , vGMSPPos , 1.0f , 1.0f , 0.0f );
		GMSPActionInterval += elapsed_time;

		// S[VI(Idle̓[v[VȂ̂ŏI͌oȂ)
		if ( !SBTE::GMSP_IsMotionPlaying( TestGMSprite_01 ) )
		{
			SBTE::GMSP_SetMotion( TestGMSprite_01 , SBTE::GetResUID("Idle") , 0 , 2 );
		}

		// sample2̃[VXV
		SBTE::GMSP_UpdateMotionFrame( TestGMSprite_01 , elapsed_time , 0 );

		// sample2XV
		SBTE::GMSP_Calc( TestGMSprite_01 , 0 );


		// RW
		vector< SBTE::GMSP_CALCED_COLLISION_PARAMS > a_cols;
		UINT32 col_ct = SBTE::GMSP_GetCalcedCollisionCount( TestGMSprite_01 );
		if ( col_ct )
		{
			a_cols.resize(col_ct);
			col_ct = SBTE::GMSP_GetCalcedCollisions( &(a_cols[0]) , col_ct , TestGMSprite_01 );

			// ŏ̋RWg
			for ( UINT32 i = 0 ; i < col_ct ; ++i )
			{
				if ( a_cols[i].Type == 0 )
				{
					b_enable_apple_col = TRUE;
					v_apple_col_pos = a_cols[i].v2Collision_CenterBegin;
					f_apple_radius = a_cols[i].fRadius;
					
					break;
				}
			}
		}

	}

	// XvCg̈ړƉ]ARW
	size_t size = aSpriteTasks.size();

	UINT32 left = 0;
	for ( int i = 0 ; i < size ; ++i )
	{
		TestSpriteTask* p_t = aSpriteTasks[i];
		p_t->x += p_t->vx * elapsed_time;
		p_t->y += p_t->vy * elapsed_time;
		p_t->r += p_t->vr * elapsed_time;

		if ( p_t->x > SPRITE_LIMIT_XP )
		{
			p_t->x = SPRITE_LIMIT_XP;
			p_t->vx = -p_t->vx;
		}
		if ( p_t->x < SPRITE_LIMIT_XM )
		{
			p_t->x = SPRITE_LIMIT_XM;
			p_t->vx = -p_t->vx;
		}
		if ( p_t->y > SPRITE_LIMIT_YP )
		{
			p_t->y = SPRITE_LIMIT_YP;
			p_t->vy = -p_t->vy;
		}
		if ( p_t->y < SPRITE_LIMIT_YM )
		{
			p_t->y = SPRITE_LIMIT_YM;
			p_t->vy = -p_t->vy;
		}
		if ( p_t->r > 3.14159f * 2.0f ) p_t->r -= 3.14159f * 2.0f;
		if ( p_t->r < -3.14159f * 2.0f ) p_t->r += 3.14159f * 2.0f;

		D3DXVECTOR2 v_pos = D3DXVECTOR2( p_t->x , p_t->y );
		SBTE::SP_SetPosScalRot( p_t->id , v_pos , p_t->s , p_t->s , p_t->r );

		// SƂ̔
		if ( b_enable_apple_col )
		{
			D3DXVECTOR2 v = v_apple_col_pos - v_pos;
			float len_sq = D3DXVec2LengthSq( &v );
			if ( len_sq < ( f_apple_radius + (p_t->s*48.0f) ) * ( f_apple_radius + (p_t->s*48.0f) ) )
			{
				// Փ
				if ( p_t->hit_interval < FLT_EPSILON )
				{
					p_t->hit_interval = 1.0f;
					Score ++;
				}
			}
		}

		// ՓˌPbȓȂ
		if ( p_t->hit_interval > 0.0f )
		{
			SBTE::SP_SetColor( p_t->id , 0x00000000 );
			p_t->hit_interval -= elapsed_time;

			// A
			if ( p_t->hit_interval < 0.0f )
			{
				SBTE::SP_SetColor( p_t->id , 0xffffffff );
			}
		}
		else
		{
			left++;
		}

	}

	// SɓĂȂXvCgɉāAo[L΂
	if ( size > 0 )
	{
		const float BAR_X = 140.0f;
		const float BAR_Y = 20.0f + 50.0f - 28.0f;
		const float BAR_W = static_cast<float>(LOGICAL_WIDTH) - BAR_X - 20.0f;
		const float BAR_H = 20.0f;

		float f_bar_r = BAR_X + ( BAR_W * (static_cast<float>(left)/static_cast<float>(size)) );

		D3DXVECTOR2 v[4];
		v[0].x = BAR_X;			v[0].y = BAR_Y;
		v[1].x = f_bar_r;		v[1].y = BAR_Y + BAR_H;
		v[2].x = BAR_X;			v[2].y = BAR_Y;
		v[3].x = f_bar_r;		v[3].y = BAR_Y + BAR_H;
		SBTE::SP_TofuPts( TestPrimitive , v[0] , v[1] , v[2] , v[3] , 0 );
	}


	// XRA\
	{
		static float script_timer = 0.0f;
		script_timer -= elapsed_time;
		if ( script_timer < FLT_EPSILON )
		{
			float pos[2] = {0,50};

			WCHAR s[1024];
			StringCbPrintfW( s , 1000 , TextString01 , Score , left );

			script_timer += 0.1f;
			SBTE::SP_InscriptionString( TestString , s , wcslen( s ) );
			SBTE::SP_SetPositioning( TestString , pos );
		}
	}

	return;
}

// XvCgj
void ReleaseSprites( void )
{
	size_t size = aSpriteTasks.size();
	for ( int i = 0 ; i < size ; ++i )
	{
		TestSpriteTask* p_t = aSpriteTasks[i];
		SBTE::ReleaseSprite( p_t->id );
		delete p_t;
	}
	aSpriteTasks.clear();

	SBTE::ReleaseSprite( TestGMSprite_01 );
	SBTE::ReleaseSprite( TestString );
	SBTE::ReleaseSprite( TestPrimitive );


	return;
}

