
#include "stdafx.h"

#include "SBTESample.h"


// SBTETvFDXCuŕ`悷郂[h

#if USING_DXLIB

static LPDIRECT3DTEXTURE9 pTempTexture		= NULL;	// `pe|


// --------------------------------------------------------------------------
// DXLibI
void DXLibFinalize( void )
{
	if ( pTempTexture )
	{
		pTempTexture->Release();
		pTempTexture = NULL;
	}

	DxLib_End();
}

// --------------------------------------------------------------------------
// C[C[W擾pe|eNX`쐬
BOOL CreateTempTexture( void )
{
	UINT32 layer_width = 0;
	UINT32 layer_height = 0;
	UINT32 layer_reserve_width = 0;
	UINT32 layer_reserve_height = 0;
	LPDIRECT3DTEXTURE9 p_tex = NULL;

	if ( pTempTexture )
	{
		pTempTexture->Release();
		pTempTexture = NULL;
	}

	// C[̎TCY擾
	if ( SBTE_FAILED( SBTE::GetLayerTexture( p_tex , layer_width , layer_height , layer_reserve_width , layer_reserve_height , LayerID ) ) )
	{
		ErrorFinalize();
		return FALSE;
	}
	// 傫POOL_SYSMEMeNX`
	if ( FAILED( pd3ddev->CreateTexture( layer_reserve_width , layer_reserve_height , 1 , 0 , D3DFMT_A8R8G8B8 , D3DPOOL_SYSTEMMEM , &pTempTexture , NULL ) ) )
	{
		ErrorFinalize();
		return FALSE;
	}

	return TRUE;
}

// --------------------------------------------------------------------------
// Alt+EnterŃEChE[hύX
BOOL Proc_ChangeWindowMode()
{
	char Buf[ 256 ] = {0};
	GetHitKeyStateAll( Buf );

	// Alt+Entero
	if ( ( (Buf[ KEY_INPUT_LALT ] == 1) || (Buf[ KEY_INPUT_RALT ] == 1) ) && ( Buf[ KEY_INPUT_RETURN ] == 1 ) )
	{
		// ݂̃eNX`󋵂o͂ĂSBTEZbg
		SBTE::ReportTextures();
		SBTE::DeviceResourceManualReset();

		// `e|j
		if ( pTempTexture )
		{
			pTempTexture->Release();
			pTempTexture = NULL;
		}

		// [hύX
		BOOL b_win = GetWindowModeFlag();

		OutputDebugString("---- CHANGE WINDOW MODE BEGIN\r\n");
		LPDIRECT3DDEVICE9 pd3ddev_old = (LPDIRECT3DDEVICE9)(GetUseDirect3DDevice9());

		ChangeWindowMode( !b_win );
		if ( b_win )
		{
			SetGraphMode( WINDOW_WIDTH , WINDOW_HEIGHT , 24 );
		}

		// VfoCX擾
		LPDIRECT3DDEVICE9 pd3ddev_new = (LPDIRECT3DDEVICE9)(GetUseDirect3DDevice9());
		OutputDebugString("---- CHANGE WINDOW MODE END\r\n");

		char s[1024];
		sprintf_s(s,1000 , "old device %08x[keeped:%08x] -->> new device %08x : \r\n" , pd3ddev_old , pd3ddev , pd3ddev_new );
		OutputDebugStringA(s);
		pd3ddev = pd3ddev_new;

		SetDrawScreen( DX_SCREEN_BACK );

		// VfoCXSBTEXgA
		SBTE::DeviceResourceManualRestore( true , false , pd3ddev , true );
		SBTE::ReportTextures();

		// `e|Đ
		CreateTempTexture();

		return TRUE;
	}
	return FALSE;
};


// --------------------------------------------------------------------------
// foCXZbgDXLibĂ΂_
void Device_ResetCallback_DXLib( void* p_params )
{
	OutputDebugString("DEVICE RESET By DXLib!\r\n");

	// ݂̃eNX`󋵂o͂ĂSBTEZbg
	SBTE::ReportTextures();
	SBTE::DeviceResourceManualReset();

	// `e|j
	if ( pTempTexture )
	{
		pTempTexture->Release();
		pTempTexture = NULL;
	}

	return;
}

// --------------------------------------------------------------------------
// foCXXgADXLibĂ΂
void Device_RestoreCallback_DXLib( void* p_params )
{
	OutputDebugString("DEVICE RESTORE By DXLib!\r\n");

	// VfoCX擾
	LPDIRECT3DDEVICE9 pd3ddev_old = pd3ddev;
	LPDIRECT3DDEVICE9 pd3ddev_new = (LPDIRECT3DDEVICE9)(GetUseDirect3DDevice9());
	char s[1024];
	sprintf_s(s,1000 , "old device %08x[keeped:%08x] -->> new device %08x : \r\n" , pd3ddev_old , pd3ddev , pd3ddev_new );
	OutputDebugStringA(s);
	pd3ddev = pd3ddev_new;

	// VfoCXSBTEXgA
	SBTE::DeviceResourceManualRestore( true , false , pd3ddev , true );
	SBTE::ReportTextures();

	// `e|Đ
	CreateTempTexture();

	return;
}



// --------------------------------------------------------------------------
// C
int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{

	// ----------------------------------------------------------------------
	// DXLib
	SetGraphMode( WINDOW_WIDTH , WINDOW_HEIGHT , 32 );
	ChangeWindowMode( true );
	if( DxLib_Init() == -1 )
	{
		return -1;
	}

	SetAlwaysRunFlag( true );
	SetDrawScreen( DX_SCREEN_BACK );
	SetGraphicsDeviceLostCallbackFunction( Device_ResetCallback_DXLib , NULL );
	SetGraphicsDeviceRestoreCallbackFunction( Device_RestoreCallback_DXLib , NULL );

	// ----------------------------------------------------------------------
	// Direct3D9foCX擾
	pd3ddev = (LPDIRECT3DDEVICE9)(GetUseDirect3DDevice9());


	// ----------------------------------------------------------------------
	// SabotenEngine

	// GW̕`惌C[̃p[^
	SBTE::SBTE_UID layer_id = 0;
	SBTE::LAYER_PARAMS layer_params;

	MakeLayerParams( layer_params );

	// NAJ[㏑w
	layer_params.ClearColor = 0xff400000;


	// 
	if ( SBTE_FAILED( SBTE::InitializeSBTE(	layer_id			// C[IDԂ
							  , WINDOW_WIDTH					// EBhẼTCYFEBhEȂꍇAC[̃ftHglTCYƂĎQƂ
							  , WINDOW_HEIGHT
							  , pd3ddev							// D3DDevice9|C^nƁAGW͎ÕfoCX쐬ɂ̃foCX𗘗pBp_d3ddevice̎QƃJE^オ܂B
							  , GetMainWindowHandle()			// EChEAvō鎞̃EChEnhBNULLȂAGWEChE쐬B
							  , NULL							// h_wnd = NULL̎́AEChENXl[Bh_wnd != NULL̂̎NULL
							  , NULL							// h_wnd = NULL̎́AEChE^CgLvVBh_wnd != NULL̂̎NULL
							  , FALSE							// p_d3ddevice == NULL̎AEChE[hŋNȂ1
							  , 0								// h_wnd == NULL̎̃EChEWBǂ炩̒lINT_MAXȂftHgl
							  , 0
							  , 0								// p_d3ddevice == NULL̎D3DDevicẽA_v^[CfbNX
							  , 0								// p_d3ddevice == NULL̎D3DDevice̐g
							  , &layer_params					// C[̃p[^ NULLȂAftHglgp
							  ,	NULL							// AP[^ubN̐ݒ
							  ,	120								// CgAP[^̃ubNTCY
							  , 20000							// CgAP[^̃ubN
							  , 1024							// XvCgpeNX`[̍őTCY=XvCg̍őTCY(`XY:ꖇ̃XvCgC[W̃TCY𒴂邱Ƃ͂ł܂)0ȂAfoCX̍ől
							  , 1024							// tHgp[NeNX`̃TCYB0ȂAfoCX̍ől
							  , FALSE							// Y+ɂ
							  , FALSE							// -Y]+ɂ
							  , NULL							// h_wnd == NULLȂAbZ[WvV[W̊֐Ă
							  , NULL							// p_d3ddevice == NULLȂAfoCXZbgɂ̊֐Ă΂
							  , NULL							// p_d3ddevice == NULLȂAfoCXXgAɂ̊֐Ă΂
							  , NULL							// h_wnd == NULLp_d3ddevice == NULLȂAEChETCYύXɂ̊֐Ă΂
							  , SBTE::LOG_VERBOSE				// Oo̓[h
							  , "SBTE.log"						// Ot@CBNULLȂst@C-gq+.log
							) ) )
	{
		DxLib_End();
		return -1;
	}
	LayerID = layer_id;

	// C[]pe|eNX`쐬
	if ( !CreateTempTexture() )
	{
		ErrorFinalize();
		return -1;
	}

	// Av̏
	if ( !AppSetup() )
	{
		ErrorFinalize();
		return -1;
	}

	// ^C}[쐬
	SBTE::CreateTimer();

	// XvCg쐬
	if ( !CreateSprites() )
	{
		ErrorFinalize();
		return -1;
	}


	// `pGraph
	BASEIMAGE BaseImage;
	INT32 hMainGraph = -1;
	memset( &BaseImage , 0 , sizeof( BASEIMAGE ) );


	// ^C}[쐬炱܂ł̌oߎԂZbg
	SBTE::ResetTimer();

	// [vp[^
	float pos_x = 300.0f;
	float pos_y = 100.0f;
	float spx = 100.0f;
	float spy = 0.0f;
	float asp = 98.0f;
	float rfps = 0.016f;

	// -------------------------------------------------------------------------
	// [v
	while( ProcessMessage() == 0 )
	{
		// [v̌oߎԂ擾
		float elapsed_time = SBTE::UpdateTimer();
		if ( elapsed_time > 0.16f ) elapsed_time = 0.16f;

		// XvCg̍XV
		UpdateSprites( elapsed_time );

		// XvCgGW̍XV
		SBTE::RESULT res_SBTE = SBTE::UpdateSBTE( elapsed_time , TRUE , TRUE , TRUE );
		if ( res_SBTE == SBTE::RESULT__REQUEST_CLOSE_APP )
		{
			// orُIBُȈꍇ́Aexception.logɃG[񂪏o͂܂B

			break;
		}

		// ------------------------------------------------------------------
		// DXLib`

		// ʃNA
		ClearDrawScreen();

		// ------------------------------------------------------------------
		// C[̃eNX`擾āADXLibGraph֓]܂B
		// SBTẼC[eNX`POOL_DEFAULTȂ̂ŁA
		// UPOOL_SYSMEMeNX`łpTempTextureփRs[Ă
		// bNărbgC[W擾܂B

		LPDIRECT3DTEXTURE9 p_tex = NULL;
		HRESULT hr = 0;
		UINT32 layer_width = 0;
		UINT32 layer_height = 0;
		UINT32 layer_reserve_width = 0;
		UINT32 layer_reserve_height = 0;
		// `惌C[eNX`擾
		if ( SBTE_SUCCEEDED( SBTE::GetLayerTexture( p_tex , layer_width , layer_height , layer_reserve_width , layer_reserve_height , LayerID ) ) )
		{
#if 1
			{
				LPDIRECT3DSURFACE9 p_surf_source;
				LPDIRECT3DSURFACE9 p_surf_dest;
				p_tex->GetSurfaceLevel( 0 , &p_surf_source );
				pTempTexture->GetSurfaceLevel( 0 , &p_surf_dest );

				if ( SUCCEEDED( pd3ddev->GetRenderTargetData( p_surf_source , p_surf_dest ) ) )
				{
					// C[eNX`bNărbgDXlib̃Ot쐬
					D3DLOCKED_RECT locked_rect;
					if ( SUCCEEDED( hr = pTempTexture->LockRect( 0 , &locked_rect , NULL , D3DLOCK_READONLY ) ) )
					{
						// 
						CreateARGB8ColorData( &BaseImage.ColorData );
						BaseImage.GraphData = locked_rect.pBits;
						BaseImage.Width = layer_width;
						BaseImage.Height = layer_height;
						BaseImage.Pitch = locked_rect.Pitch;
						BaseImage.MipMapCount = 0;
						BaseImage.GraphDataCount = 0;
				
						if( hMainGraph == -1 )
						{
							// 񐶐
							hMainGraph = CreateGraphFromBaseImage( &BaseImage );
						}
						else
						{
							// Qڈȍ~̃Rs[
							ReCreateGraphFromBaseImage( &BaseImage , hMainGraph );
						}

						pTempTexture->UnlockRect( 0 );
					}
				}

				// 擾T[tFCX
				p_surf_source->Release();
				p_surf_dest->Release();
			}

			// DXLibŕ`
			DrawGraph( 0 , 0 , hMainGraph , FALSE );
		}
#endif

		// -----------------------------------------------------------------
		// eXg
		DrawString( pos_x , pos_y , "DxLib`" , GetColor( 255 , 255 , 128 ) );

		float dt = elapsed_time;

		spy += asp * dt;
		pos_y += spy * dt;
		pos_x += spx * dt;

		if ( pos_y > 400.0f )
		{
			pos_y = 400.0f;
			spy *= -1.0f;
		}
		if ( pos_x > 500.0f )
		{
			pos_x = 500.0f;
			spx = -100.0f;
		
		}
		if ( pos_x < 100.0f )
		{
			pos_x = 100.0f;
			spx = 100.0f;
		
		}
		// -----------------------------------------------------------------

		// -----------------------------------------------------------------
		// ʍXV
//		WaitVSync(1);
		ScreenFlip();
		// -----------------------------------------------------------------

		// ------------------------------------------------------------------
		// EChE[h̕ύX
		if ( Proc_ChangeWindowMode() )
		{
			// foCXXgɃOtj
			DeleteGraph( hMainGraph );
			hMainGraph = -1; 
		}
	}
	// [v
	// -------------------------------------------------------------------------
	
	// I
	Finalize( TRUE , TRUE );

	return 0;
}

#endif

